package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A security role.
 */
@Addresses({"/subsystem=messaging-activemq/server=*/security-setting=*/role=*",
		"/subsystem=messaging-activemq/server=*/core-address=*/role=*"})
@ResourceType("role")
public class Role<T extends Role<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean consume;
	private Boolean createDurableQueue;
	private Boolean createNonDurableQueue;
	private Boolean deleteDurableQueue;
	private Boolean deleteNonDurableQueue;
	private Boolean manage;
	private Boolean send;

	public Role(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * his permission allows the user to consume a message from a queue bound to
	 * matching addresses.
	 */
	@ModelNodeBinding(detypedName = "consume")
	public Boolean consume() {
		return this.consume;
	}

	/**
	 * his permission allows the user to consume a message from a queue bound to
	 * matching addresses.
	 */
	@SuppressWarnings("unchecked")
	public T consume(Boolean value) {
		Object oldValue = this.consume;
		this.consume = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("consume", oldValue, value);
		return (T) this;
	}

	/**
	 * This permission allows the user to create a durable queue.
	 */
	@ModelNodeBinding(detypedName = "create-durable-queue")
	public Boolean createDurableQueue() {
		return this.createDurableQueue;
	}

	/**
	 * This permission allows the user to create a durable queue.
	 */
	@SuppressWarnings("unchecked")
	public T createDurableQueue(Boolean value) {
		Object oldValue = this.createDurableQueue;
		this.createDurableQueue = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("createDurableQueue", oldValue, value);
		return (T) this;
	}

	/**
	 * This permission allows the user to create a temporary queue.
	 */
	@ModelNodeBinding(detypedName = "create-non-durable-queue")
	public Boolean createNonDurableQueue() {
		return this.createNonDurableQueue;
	}

	/**
	 * This permission allows the user to create a temporary queue.
	 */
	@SuppressWarnings("unchecked")
	public T createNonDurableQueue(Boolean value) {
		Object oldValue = this.createNonDurableQueue;
		this.createNonDurableQueue = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("createNonDurableQueue", oldValue,
					value);
		return (T) this;
	}

	/**
	 * This permission allows the user to delete a durable queue.
	 */
	@ModelNodeBinding(detypedName = "delete-durable-queue")
	public Boolean deleteDurableQueue() {
		return this.deleteDurableQueue;
	}

	/**
	 * This permission allows the user to delete a durable queue.
	 */
	@SuppressWarnings("unchecked")
	public T deleteDurableQueue(Boolean value) {
		Object oldValue = this.deleteDurableQueue;
		this.deleteDurableQueue = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("deleteDurableQueue", oldValue, value);
		return (T) this;
	}

	/**
	 * This permission allows the user to delete a temporary queue.
	 */
	@ModelNodeBinding(detypedName = "delete-non-durable-queue")
	public Boolean deleteNonDurableQueue() {
		return this.deleteNonDurableQueue;
	}

	/**
	 * This permission allows the user to delete a temporary queue.
	 */
	@SuppressWarnings("unchecked")
	public T deleteNonDurableQueue(Boolean value) {
		Object oldValue = this.deleteNonDurableQueue;
		this.deleteNonDurableQueue = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("deleteNonDurableQueue", oldValue,
					value);
		return (T) this;
	}

	/**
	 * This permission allows the user to invoke management operations by
	 * sending management messages to the management address.
	 */
	@ModelNodeBinding(detypedName = "manage")
	public Boolean manage() {
		return this.manage;
	}

	/**
	 * This permission allows the user to invoke management operations by
	 * sending management messages to the management address.
	 */
	@SuppressWarnings("unchecked")
	public T manage(Boolean value) {
		Object oldValue = this.manage;
		this.manage = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("manage", oldValue, value);
		return (T) this;
	}

	/**
	 * This permission allows the user to send a message to matching addresses.
	 */
	@ModelNodeBinding(detypedName = "send")
	public Boolean send() {
		return this.send;
	}

	/**
	 * This permission allows the user to send a message to matching addresses.
	 */
	@SuppressWarnings("unchecked")
	public T send(Boolean value) {
		Object oldValue = this.send;
		this.send = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("send", oldValue, value);
		return (T) this;
	}
}