package org.wildfly.swarm.config.messaging.activemq.server.ha_policy.shared_store_colocated;

import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.shared_store_colocated.MasterConfiguration;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface MasterConfigurationConsumer<T extends MasterConfiguration<T>> {

	/**
	 * Configure a pre-constructed instance of MasterConfiguration resource
	 * 
	 * @parameter Instance of MasterConfiguration to configure
	 * @return nothing
	 */
	void accept(T value);

	default MasterConfigurationConsumer<T> andThen(
			MasterConfigurationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}