package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.remoting.OutboundConnection;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface OutboundConnectionConsumer<T extends OutboundConnection<T>> {

	/**
	 * Configure a pre-constructed instance of OutboundConnection resource
	 * 
	 * @parameter Instance of OutboundConnection to configure
	 * @return nothing
	 */
	void accept(T value);

	default OutboundConnectionConsumer<T> andThen(
			OutboundConnectionConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}