package org.wildfly.swarm.config.security;
public enum Flag {
	REQUIRED("required"), REQUISITE("requisite"), SUFFICIENT("sufficient"), OPTIONAL(
			"optional");

	private final String allowedValue;

	/**
	 * Returns the allowed value for the management model.
	 * 
	 * @return the allowed model value
	 */
	public String getAllowedValue() {
		return allowedValue;
	}

	Flag(String allowedValue) {
		this.allowedValue = allowedValue;
	}

	@Override
	public String toString() {
		return allowedValue;
	}
}