package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.undertow.configuration.File;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface FileConsumer<T extends File<T>> {

	/**
	 * Configure a pre-constructed instance of File resource
	 * 
	 * @parameter Instance of File to configure
	 * @return nothing
	 */
	void accept(T value);

	default FileConsumer<T> andThen(FileConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}