package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.undertow.servlet_container.MimeMapping;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface MimeMappingConsumer<T extends MimeMapping<T>> {

	/**
	 * Configure a pre-constructed instance of MimeMapping resource
	 * 
	 * @parameter Instance of MimeMapping to configure
	 * @return nothing
	 */
	void accept(T value);

	default MimeMappingConsumer<T> andThen(MimeMappingConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}