/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.access;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import org.wildfly.swarm.config.management.access.syslog_handler.TcpProtocol;
import org.wildfly.swarm.config.management.access.syslog_handler.TcpProtocolConsumer;
import org.wildfly.swarm.config.management.access.syslog_handler.TcpProtocolSupplier;
import org.wildfly.swarm.config.management.access.syslog_handler.TlsProtocol;
import org.wildfly.swarm.config.management.access.syslog_handler.TlsProtocolConsumer;
import org.wildfly.swarm.config.management.access.syslog_handler.TlsProtocolSupplier;
import org.wildfly.swarm.config.management.access.syslog_handler.UdpProtocol;
import org.wildfly.swarm.config.management.access.syslog_handler.UdpProtocolConsumer;
import org.wildfly.swarm.config.management.access.syslog_handler.UdpProtocolSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/core-service=management/access=audit/syslog-handler=*")
@ResourceType(value="syslog-handler")
public class SyslogHandler<T extends SyslogHandler<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private String appName;
    private Boolean disabledDueToFailure;
    private Facility facility;
    private Integer failureCount;
    private String formatter;
    private Integer maxFailureCount;
    private Integer maxLength;
    private SyslogFormat syslogFormat;
    private Boolean truncate;
    private SyslogHandlerResources subresources = new SyslogHandlerResources();

    public SyslogHandler(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="app-name")
    public String appName() {
        return this.appName;
    }

    public T appName(String value) {
        String oldValue = this.appName;
        this.appName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("appName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="disabled-due-to-failure")
    public Boolean disabledDueToFailure() {
        return this.disabledDueToFailure;
    }

    public T disabledDueToFailure(Boolean value) {
        Boolean oldValue = this.disabledDueToFailure;
        this.disabledDueToFailure = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("disabledDueToFailure", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    public T facility(String facility) {
        if (facility == null) {
            this.facility = null;
        } else {
            boolean found = false;
            for (Facility e : Facility.values()) {
                if (!e.toString().equals(facility)) continue;
                this.facility(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", facility, Arrays.asList(Facility.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="facility")
    public Facility facility() {
        return this.facility;
    }

    public T facility(Facility value) {
        Facility oldValue = this.facility;
        this.facility = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("facility", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="failure-count")
    public Integer failureCount() {
        return this.failureCount;
    }

    public T failureCount(Integer value) {
        Integer oldValue = this.failureCount;
        this.failureCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("failureCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="formatter")
    public String formatter() {
        return this.formatter;
    }

    public T formatter(String value) {
        String oldValue = this.formatter;
        this.formatter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("formatter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-failure-count")
    public Integer maxFailureCount() {
        return this.maxFailureCount;
    }

    public T maxFailureCount(Integer value) {
        Integer oldValue = this.maxFailureCount;
        this.maxFailureCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxFailureCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-length")
    public Integer maxLength() {
        return this.maxLength;
    }

    public T maxLength(Integer value) {
        Integer oldValue = this.maxLength;
        this.maxLength = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxLength", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    public T syslogFormat(String syslogFormat) {
        if (syslogFormat == null) {
            this.syslogFormat = null;
        } else {
            boolean found = false;
            for (SyslogFormat e : SyslogFormat.values()) {
                if (!e.toString().equals(syslogFormat)) continue;
                this.syslogFormat(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", syslogFormat, Arrays.asList(SyslogFormat.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="syslog-format")
    public SyslogFormat syslogFormat() {
        return this.syslogFormat;
    }

    public T syslogFormat(SyslogFormat value) {
        SyslogFormat oldValue = this.syslogFormat;
        this.syslogFormat = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("syslogFormat", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="truncate")
    public Boolean truncate() {
        return this.truncate;
    }

    public T truncate(Boolean value) {
        Boolean oldValue = this.truncate;
        this.truncate = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("truncate", oldValue, value);
        }
        return (T)this;
    }

    public SyslogHandlerResources subresources() {
        return this.subresources;
    }

    public T tcpProtocol(TcpProtocol value) {
        this.subresources.tcpProtocol = value;
        return (T)this;
    }

    public T tcpProtocol(TcpProtocolConsumer consumer) {
        TcpProtocol child = new TcpProtocol();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.tcpProtocol = child;
        return (T)this;
    }

    public T tcpProtocol() {
        TcpProtocol child = new TcpProtocol();
        this.subresources.tcpProtocol = child;
        return (T)this;
    }

    public T tcpProtocol(TcpProtocolSupplier supplier) {
        this.subresources.tcpProtocol = supplier.get();
        return (T)this;
    }

    public T udpProtocol(UdpProtocol value) {
        this.subresources.udpProtocol = value;
        return (T)this;
    }

    public T udpProtocol(UdpProtocolConsumer consumer) {
        UdpProtocol child = new UdpProtocol();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.udpProtocol = child;
        return (T)this;
    }

    public T udpProtocol() {
        UdpProtocol child = new UdpProtocol();
        this.subresources.udpProtocol = child;
        return (T)this;
    }

    public T udpProtocol(UdpProtocolSupplier supplier) {
        this.subresources.udpProtocol = supplier.get();
        return (T)this;
    }

    public T tlsProtocol(TlsProtocol value) {
        this.subresources.tlsProtocol = value;
        return (T)this;
    }

    public T tlsProtocol(TlsProtocolConsumer consumer) {
        TlsProtocol child = new TlsProtocol();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.tlsProtocol = child;
        return (T)this;
    }

    public T tlsProtocol() {
        TlsProtocol child = new TlsProtocol();
        this.subresources.tlsProtocol = child;
        return (T)this;
    }

    public T tlsProtocol(TlsProtocolSupplier supplier) {
        this.subresources.tlsProtocol = supplier.get();
        return (T)this;
    }

    public static enum SyslogFormat {
        RFC5424("RFC5424"),
        RFC3164("RFC3164");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private SyslogFormat(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum Facility {
        KERNEL("KERNEL"),
        USER_LEVEL("USER_LEVEL"),
        MAIL_SYSTEM("MAIL_SYSTEM"),
        SYSTEM_DAEMONS("SYSTEM_DAEMONS"),
        SECURITY("SECURITY"),
        SYSLOGD("SYSLOGD"),
        LINE_PRINTER("LINE_PRINTER"),
        NETWORK_NEWS("NETWORK_NEWS"),
        UUCP("UUCP"),
        CLOCK_DAEMON("CLOCK_DAEMON"),
        SECURITY2("SECURITY2"),
        FTP_DAEMON("FTP_DAEMON"),
        NTP("NTP"),
        LOG_AUDIT("LOG_AUDIT"),
        LOG_ALERT("LOG_ALERT"),
        CLOCK_DAEMON2("CLOCK_DAEMON2"),
        LOCAL_USE_0("LOCAL_USE_0"),
        LOCAL_USE_1("LOCAL_USE_1"),
        LOCAL_USE_2("LOCAL_USE_2"),
        LOCAL_USE_3("LOCAL_USE_3"),
        LOCAL_USE_4("LOCAL_USE_4"),
        LOCAL_USE_5("LOCAL_USE_5"),
        LOCAL_USE_6("LOCAL_USE_6"),
        LOCAL_USE_7("LOCAL_USE_7");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Facility(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class SyslogHandlerResources {
        private TcpProtocol tcpProtocol;
        private UdpProtocol udpProtocol;
        private TlsProtocol tlsProtocol;

        @Subresource
        public TcpProtocol tcpProtocol() {
            return this.tcpProtocol;
        }

        @Subresource
        public UdpProtocol udpProtocol() {
            return this.udpProtocol;
        }

        @Subresource
        public TlsProtocol tlsProtocol() {
            return this.tlsProtocol;
        }
    }
}

