/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.remoting;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.swarm.config.remoting.PolicySASLPolicy;
import org.wildfly.swarm.config.remoting.PolicySASLPolicyConsumer;
import org.wildfly.swarm.config.remoting.PolicySASLPolicySupplier;
import org.wildfly.swarm.config.remoting.Property;
import org.wildfly.swarm.config.remoting.PropertyConsumer;
import org.wildfly.swarm.config.remoting.PropertySupplier;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Addresses(value={"/subsystem=remoting/http-connector=*/security=sasl", "/subsystem=remoting/connector=*/security=sasl"})
@ResourceType(value="security")
@Implicit
public class SASLSecurity<T extends SASLSecurity<T>> {
    private String key = "sasl";
    private PropertyChangeSupport pcs;
    private List<String> includeMechanisms;
    private List<String> qop;
    private Boolean reuseSession;
    private Boolean serverAuth;
    private List<String> strength;
    private SASLSecurityResources subresources = new SASLSecurityResources();

    public SASLSecurity() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="include-mechanisms")
    public List<String> includeMechanisms() {
        return this.includeMechanisms;
    }

    public T includeMechanisms(List<String> value) {
        List<String> oldValue = this.includeMechanisms;
        this.includeMechanisms = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("includeMechanisms", oldValue, value);
        }
        return (T)this;
    }

    public T includeMechanism(String value) {
        if (this.includeMechanisms == null) {
            this.includeMechanisms = new ArrayList<String>();
        }
        this.includeMechanisms.add(value);
        return (T)this;
    }

    public T includeMechanisms(String ... args) {
        this.includeMechanisms(Arrays.asList(args));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="qop")
    public List<String> qop() {
        return this.qop;
    }

    public T qop(List<String> value) {
        List<String> oldValue = this.qop;
        this.qop = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("qop", oldValue, value);
        }
        return (T)this;
    }

    public T qop(String value) {
        if (this.qop == null) {
            this.qop = new ArrayList<String>();
        }
        this.qop.add(value);
        return (T)this;
    }

    public T qop(String ... args) {
        this.qop(Arrays.asList(args));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reuse-session")
    public Boolean reuseSession() {
        return this.reuseSession;
    }

    public T reuseSession(Boolean value) {
        Boolean oldValue = this.reuseSession;
        this.reuseSession = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reuseSession", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-auth")
    public Boolean serverAuth() {
        return this.serverAuth;
    }

    public T serverAuth(Boolean value) {
        Boolean oldValue = this.serverAuth;
        this.serverAuth = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverAuth", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="strength")
    public List<String> strength() {
        return this.strength;
    }

    public T strength(List<String> value) {
        List<String> oldValue = this.strength;
        this.strength = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("strength", oldValue, value);
        }
        return (T)this;
    }

    public T strength(String value) {
        if (this.strength == null) {
            this.strength = new ArrayList<String>();
        }
        this.strength.add(value);
        return (T)this;
    }

    public T strength(String ... args) {
        this.strength(Arrays.asList(args));
        return (T)this;
    }

    public SASLSecurityResources subresources() {
        return this.subresources;
    }

    public T properties(List<Property> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConsumer consumer) {
        Property child = new Property(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    public T property(PropertySupplier supplier) {
        this.property(supplier.get());
        return (T)this;
    }

    public T policySaslPolicy(PolicySASLPolicy value) {
        this.subresources.policySaslPolicy = value;
        return (T)this;
    }

    public T policySaslPolicy(PolicySASLPolicyConsumer consumer) {
        PolicySASLPolicy child = new PolicySASLPolicy();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.policySaslPolicy = child;
        return (T)this;
    }

    public T policySaslPolicy() {
        PolicySASLPolicy child = new PolicySASLPolicy();
        this.subresources.policySaslPolicy = child;
        return (T)this;
    }

    public T policySaslPolicy(PolicySASLPolicySupplier supplier) {
        this.subresources.policySaslPolicy = supplier.get();
        return (T)this;
    }

    public static class SASLSecurityResources {
        private List<Property> properties = new ArrayList<Property>();
        private PolicySASLPolicy policySaslPolicy;

        @Subresource
        public List<Property> properties() {
            return this.properties;
        }

        public Property property(String key) {
            return this.properties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public PolicySASLPolicy policySaslPolicy() {
            return this.policySaslPolicy;
        }
    }
}

