package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.ejb3.Cache;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface CacheConsumer<T extends Cache<T>> {

	/**
	 * Configure a pre-constructed instance of Cache resource
	 * 
	 * @parameter Instance of Cache to configure
	 * @return nothing
	 */
	void accept(T value);

	default CacheConsumer<T> andThen(CacheConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}