package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.undertow.configuration.ReverseProxy;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ReverseProxyConsumer<T extends ReverseProxy<T>> {

	/**
	 * Configure a pre-constructed instance of ReverseProxy resource
	 * 
	 * @parameter Instance of ReverseProxy to configure
	 * @return nothing
	 */
	void accept(T value);

	default ReverseProxyConsumer<T> andThen(ReverseProxyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}