package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Sar;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface SarConsumer<T extends Sar<T>> {

	/**
	 * Configure a pre-constructed instance of Sar resource
	 * 
	 * @parameter Instance of Sar to configure
	 * @return nothing
	 */
	void accept(T value);

	default SarConsumer<T> andThen(SarConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}