package org.wildfly.swarm.config.ee;

import org.wildfly.swarm.config.ee.DefaultBindingsService;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface DefaultBindingsServiceConsumer<T extends DefaultBindingsService<T>> {

	/**
	 * Configure a pre-constructed instance of DefaultBindingsService resource
	 * 
	 * @parameter Instance of DefaultBindingsService to configure
	 * @return nothing
	 */
	void accept(T value);

	default DefaultBindingsServiceConsumer<T> andThen(
			DefaultBindingsServiceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}