package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.ReplicatedCache;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ReplicatedCacheConsumer<T extends ReplicatedCache<T>> {

	/**
	 * Configure a pre-constructed instance of ReplicatedCache resource
	 * 
	 * @parameter Instance of ReplicatedCache to configure
	 * @return nothing
	 */
	void accept(T value);

	default ReplicatedCacheConsumer<T> andThen(ReplicatedCacheConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}