package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.management.access.RoleMapping;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface RoleMappingConsumer<T extends RoleMapping<T>> {

	/**
	 * Configure a pre-constructed instance of RoleMapping resource
	 * 
	 * @parameter Instance of RoleMapping to configure
	 * @return nothing
	 */
	void accept(T value);

	default RoleMappingConsumer<T> andThen(RoleMappingConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}