package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.management.access.SensitivityClassificationConstraint;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface SensitivityClassificationConstraintConsumer<T extends SensitivityClassificationConstraint<T>> {

	/**
	 * Configure a pre-constructed instance of
	 * SensitivityClassificationConstraint resource
	 * 
	 * @parameter Instance of SensitivityClassificationConstraint to configure
	 * @return nothing
	 */
	void accept(T value);

	default SensitivityClassificationConstraintConsumer<T> andThen(
			SensitivityClassificationConstraintConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}