package org.wildfly.swarm.config.management.access.constraint;

import org.wildfly.swarm.config.management.access.constraint.Type;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface TypeConsumer<T extends Type<T>> {

	/**
	 * Configure a pre-constructed instance of Type resource
	 * 
	 * @parameter Instance of Type to configure
	 * @return nothing
	 */
	void accept(T value);

	default TypeConsumer<T> andThen(TypeConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}