package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Defines a way in which remote connections can be made to the ActiveMQ server.
 */
@Address("/subsystem=messaging-activemq/server=*/remote-acceptor=*")
@ResourceType("remote-acceptor")
public class RemoteAcceptor<T extends RemoteAcceptor<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Map params;
	private String socketBinding;
	private Boolean started;

	public RemoteAcceptor(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to
	 * configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to
	 * configure it.
	 */
	@SuppressWarnings("unchecked")
	public T params(Map value) {
		Object oldValue = this.params;
		this.params = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("params", oldValue, value);
		return (T) this;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to
	 * configure it.
	 */
	@SuppressWarnings("unchecked")
	public T param(String key, Object value) {
		if (this.params == null) {
			this.params = new java.util.HashMap<>();
		}
		this.params.put(key, value);
		return (T) this;
	}

	/**
	 * The socket binding that the acceptor will use to accept connections.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The socket binding that the acceptor will use to accept connections.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether this acceptor is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether this acceptor is started.
	 */
	@SuppressWarnings("unchecked")
	public T started(Boolean value) {
		Object oldValue = this.started;
		this.started = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("started", oldValue, value);
		return (T) this;
	}
}