package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.undertow.configuration.ConnectionLimit;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ConnectionLimitConsumer<T extends ConnectionLimit<T>> {

	/**
	 * Configure a pre-constructed instance of ConnectionLimit resource
	 * 
	 * @parameter Instance of ConnectionLimit to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConnectionLimitConsumer<T> andThen(ConnectionLimitConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}