/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=iiop-openjdk")
@ResourceType(value="subsystem")
@Implicit
public class IIOPOpenjdk<T extends IIOPOpenjdk<T>> {
    private String key = "iiop-openjdk";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Map properties;
    private AuthMethod authMethod;
    private String realm;
    private Boolean required;
    private Security security;
    private Transactions transactions;
    private Boolean exportCorbaloc;
    private String rootContext;
    private String giopVersion;
    private String persistentServerId;
    private String socketBinding;
    private String sslSocketBinding;
    private CallerPropagation callerPropagation;
    private Boolean addComponentViaInterceptor;
    private ClientRequires clientRequires;
    private ClientSupports clientSupports;
    private String securityDomain;
    private ServerRequires serverRequires;
    private ServerSupports serverSupports;
    private Boolean supportSsl;
    private Integer highWaterMark;
    private Integer numberToReclaim;
    private Confidentiality confidentiality;
    private DetectMisordering detectMisordering;
    private DetectReplay detectReplay;
    private Integrity integrity;
    private TrustInClient trustInClient;
    private TrustInTarget trustInTarget;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="properties")
    public Map properties() {
        return this.properties;
    }

    public T properties(Map value) {
        Map oldValue = this.properties;
        this.properties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("properties", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return (T)this;
    }

    @Deprecated
    public T authMethod(String authMethod) {
        if (authMethod == null) {
            this.authMethod = null;
        } else {
            boolean found = false;
            for (AuthMethod e : AuthMethod.values()) {
                if (!e.toString().equals(authMethod)) continue;
                this.authMethod(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", authMethod, Arrays.asList(AuthMethod.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="auth-method")
    public AuthMethod authMethod() {
        return this.authMethod;
    }

    public T authMethod(AuthMethod value) {
        AuthMethod oldValue = this.authMethod;
        this.authMethod = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authMethod", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="realm")
    public String realm() {
        return this.realm;
    }

    public T realm(String value) {
        String oldValue = this.realm;
        this.realm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("realm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="required")
    public Boolean required() {
        return this.required;
    }

    public T required(Boolean value) {
        Boolean oldValue = this.required;
        this.required = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("required", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    public T security(String security) {
        if (security == null) {
            this.security = null;
        } else {
            boolean found = false;
            for (Security e : Security.values()) {
                if (!e.toString().equals(security)) continue;
                this.security(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", security, Arrays.asList(Security.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security")
    public Security security() {
        return this.security;
    }

    public T security(Security value) {
        Security oldValue = this.security;
        this.security = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("security", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @Deprecated
    public T transactions(String transactions) {
        if (transactions == null) {
            this.transactions = null;
        } else {
            boolean found = false;
            for (Transactions e : Transactions.values()) {
                if (!e.toString().equals(transactions)) continue;
                this.transactions(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", transactions, Arrays.asList(Transactions.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transactions")
    public Transactions transactions() {
        return this.transactions;
    }

    public T transactions(Transactions value) {
        Transactions oldValue = this.transactions;
        this.transactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transactions", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="export-corbaloc")
    public Boolean exportCorbaloc() {
        return this.exportCorbaloc;
    }

    public T exportCorbaloc(Boolean value) {
        Boolean oldValue = this.exportCorbaloc;
        this.exportCorbaloc = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exportCorbaloc", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="root-context")
    public String rootContext() {
        return this.rootContext;
    }

    public T rootContext(String value) {
        String oldValue = this.rootContext;
        this.rootContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("rootContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="giop-version")
    public String giopVersion() {
        return this.giopVersion;
    }

    public T giopVersion(String value) {
        String oldValue = this.giopVersion;
        this.giopVersion = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("giopVersion", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="persistent-server-id")
    public String persistentServerId() {
        return this.persistentServerId;
    }

    public T persistentServerId(String value) {
        String oldValue = this.persistentServerId;
        this.persistentServerId = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("persistentServerId", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-binding")
    public String socketBinding() {
        return this.socketBinding;
    }

    public T socketBinding(String value) {
        String oldValue = this.socketBinding;
        this.socketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-socket-binding")
    public String sslSocketBinding() {
        return this.sslSocketBinding;
    }

    public T sslSocketBinding(String value) {
        String oldValue = this.sslSocketBinding;
        this.sslSocketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslSocketBinding", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    public T callerPropagation(String callerPropagation) {
        if (callerPropagation == null) {
            this.callerPropagation = null;
        } else {
            boolean found = false;
            for (CallerPropagation e : CallerPropagation.values()) {
                if (!e.toString().equals(callerPropagation)) continue;
                this.callerPropagation(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", callerPropagation, Arrays.asList(CallerPropagation.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="caller-propagation")
    public CallerPropagation callerPropagation() {
        return this.callerPropagation;
    }

    public T callerPropagation(CallerPropagation value) {
        CallerPropagation oldValue = this.callerPropagation;
        this.callerPropagation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("callerPropagation", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="add-component-via-interceptor")
    public Boolean addComponentViaInterceptor() {
        return this.addComponentViaInterceptor;
    }

    public T addComponentViaInterceptor(Boolean value) {
        Boolean oldValue = this.addComponentViaInterceptor;
        this.addComponentViaInterceptor = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("addComponentViaInterceptor", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    public T clientRequires(String clientRequires) {
        if (clientRequires == null) {
            this.clientRequires = null;
        } else {
            boolean found = false;
            for (ClientRequires e : ClientRequires.values()) {
                if (!e.toString().equals(clientRequires)) continue;
                this.clientRequires(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", clientRequires, Arrays.asList(ClientRequires.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="client-requires")
    public ClientRequires clientRequires() {
        return this.clientRequires;
    }

    public T clientRequires(ClientRequires value) {
        ClientRequires oldValue = this.clientRequires;
        this.clientRequires = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clientRequires", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @Deprecated
    public T clientSupports(String clientSupports) {
        if (clientSupports == null) {
            this.clientSupports = null;
        } else {
            boolean found = false;
            for (ClientSupports e : ClientSupports.values()) {
                if (!e.toString().equals(clientSupports)) continue;
                this.clientSupports(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", clientSupports, Arrays.asList(ClientSupports.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="client-supports")
    public ClientSupports clientSupports() {
        return this.clientSupports;
    }

    public T clientSupports(ClientSupports value) {
        ClientSupports oldValue = this.clientSupports;
        this.clientSupports = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clientSupports", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    public T serverRequires(String serverRequires) {
        if (serverRequires == null) {
            this.serverRequires = null;
        } else {
            boolean found = false;
            for (ServerRequires e : ServerRequires.values()) {
                if (!e.toString().equals(serverRequires)) continue;
                this.serverRequires(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", serverRequires, Arrays.asList(ServerRequires.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-requires")
    public ServerRequires serverRequires() {
        return this.serverRequires;
    }

    public T serverRequires(ServerRequires value) {
        ServerRequires oldValue = this.serverRequires;
        this.serverRequires = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverRequires", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @Deprecated
    public T serverSupports(String serverSupports) {
        if (serverSupports == null) {
            this.serverSupports = null;
        } else {
            boolean found = false;
            for (ServerSupports e : ServerSupports.values()) {
                if (!e.toString().equals(serverSupports)) continue;
                this.serverSupports(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", serverSupports, Arrays.asList(ServerSupports.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-supports")
    public ServerSupports serverSupports() {
        return this.serverSupports;
    }

    public T serverSupports(ServerSupports value) {
        ServerSupports oldValue = this.serverSupports;
        this.serverSupports = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverSupports", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="support-ssl")
    public Boolean supportSsl() {
        return this.supportSsl;
    }

    public T supportSsl(Boolean value) {
        Boolean oldValue = this.supportSsl;
        this.supportSsl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("supportSsl", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="high-water-mark")
    public Integer highWaterMark() {
        return this.highWaterMark;
    }

    public T highWaterMark(Integer value) {
        Integer oldValue = this.highWaterMark;
        this.highWaterMark = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("highWaterMark", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-to-reclaim")
    public Integer numberToReclaim() {
        return this.numberToReclaim;
    }

    public T numberToReclaim(Integer value) {
        Integer oldValue = this.numberToReclaim;
        this.numberToReclaim = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberToReclaim", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    public T confidentiality(String confidentiality) {
        if (confidentiality == null) {
            this.confidentiality = null;
        } else {
            boolean found = false;
            for (Confidentiality e : Confidentiality.values()) {
                if (!e.toString().equals(confidentiality)) continue;
                this.confidentiality(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", confidentiality, Arrays.asList(Confidentiality.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="confidentiality")
    public Confidentiality confidentiality() {
        return this.confidentiality;
    }

    public T confidentiality(Confidentiality value) {
        Confidentiality oldValue = this.confidentiality;
        this.confidentiality = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("confidentiality", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @Deprecated
    public T detectMisordering(String detectMisordering) {
        if (detectMisordering == null) {
            this.detectMisordering = null;
        } else {
            boolean found = false;
            for (DetectMisordering e : DetectMisordering.values()) {
                if (!e.toString().equals(detectMisordering)) continue;
                this.detectMisordering(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", detectMisordering, Arrays.asList(DetectMisordering.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="detect-misordering")
    public DetectMisordering detectMisordering() {
        return this.detectMisordering;
    }

    public T detectMisordering(DetectMisordering value) {
        DetectMisordering oldValue = this.detectMisordering;
        this.detectMisordering = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("detectMisordering", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @Deprecated
    public T detectReplay(String detectReplay) {
        if (detectReplay == null) {
            this.detectReplay = null;
        } else {
            boolean found = false;
            for (DetectReplay e : DetectReplay.values()) {
                if (!e.toString().equals(detectReplay)) continue;
                this.detectReplay(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", detectReplay, Arrays.asList(DetectReplay.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="detect-replay")
    public DetectReplay detectReplay() {
        return this.detectReplay;
    }

    public T detectReplay(DetectReplay value) {
        DetectReplay oldValue = this.detectReplay;
        this.detectReplay = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("detectReplay", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @Deprecated
    public T integrity(String integrity) {
        if (integrity == null) {
            this.integrity = null;
        } else {
            boolean found = false;
            for (Integrity e : Integrity.values()) {
                if (!e.toString().equals(integrity)) continue;
                this.integrity(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", integrity, Arrays.asList(Integrity.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="integrity")
    public Integrity integrity() {
        return this.integrity;
    }

    public T integrity(Integrity value) {
        Integrity oldValue = this.integrity;
        this.integrity = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("integrity", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @Deprecated
    public T trustInClient(String trustInClient) {
        if (trustInClient == null) {
            this.trustInClient = null;
        } else {
            boolean found = false;
            for (TrustInClient e : TrustInClient.values()) {
                if (!e.toString().equals(trustInClient)) continue;
                this.trustInClient(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", trustInClient, Arrays.asList(TrustInClient.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="trust-in-client")
    public TrustInClient trustInClient() {
        return this.trustInClient;
    }

    public T trustInClient(TrustInClient value) {
        TrustInClient oldValue = this.trustInClient;
        this.trustInClient = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("trustInClient", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @Deprecated
    public T trustInTarget(String trustInTarget) {
        if (trustInTarget == null) {
            this.trustInTarget = null;
        } else {
            boolean found = false;
            for (TrustInTarget e : TrustInTarget.values()) {
                if (!e.toString().equals(trustInTarget)) continue;
                this.trustInTarget(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", trustInTarget, Arrays.asList(TrustInTarget.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="trust-in-target")
    public TrustInTarget trustInTarget() {
        return this.trustInTarget;
    }

    public T trustInTarget(TrustInTarget value) {
        TrustInTarget oldValue = this.trustInTarget;
        this.trustInTarget = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("trustInTarget", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    public static enum TrustInTarget {
        NONE("none"),
        SUPPORTED("supported");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private TrustInTarget(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum TrustInClient {
        NONE("none"),
        SUPPORTED("supported"),
        REQUIRED("required");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private TrustInClient(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum Integrity {
        NONE("none"),
        SUPPORTED("supported"),
        REQUIRED("required");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Integrity(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum DetectReplay {
        NONE("none"),
        SUPPORTED("supported"),
        REQUIRED("required");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private DetectReplay(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum DetectMisordering {
        NONE("none"),
        SUPPORTED("supported"),
        REQUIRED("required");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private DetectMisordering(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum Confidentiality {
        NONE("none"),
        SUPPORTED("supported"),
        REQUIRED("required");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Confidentiality(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum ServerSupports {
        NONE("None"),
        SERVERAUTH("ServerAuth"),
        CLIENTAUTH("ClientAuth"),
        MUTUALAUTH("MutualAuth");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private ServerSupports(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum ServerRequires {
        NONE("None"),
        SERVERAUTH("ServerAuth"),
        CLIENTAUTH("ClientAuth"),
        MUTUALAUTH("MutualAuth");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private ServerRequires(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum ClientSupports {
        NONE("None"),
        SERVERAUTH("ServerAuth"),
        CLIENTAUTH("ClientAuth"),
        MUTUALAUTH("MutualAuth");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private ClientSupports(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum ClientRequires {
        NONE("None"),
        SERVERAUTH("ServerAuth"),
        CLIENTAUTH("ClientAuth"),
        MUTUALAUTH("MutualAuth");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private ClientRequires(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum CallerPropagation {
        NONE("none"),
        SUPPORTED("supported");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private CallerPropagation(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum Transactions {
        FULL("full"),
        NONE("none"),
        SPEC("spec");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Transactions(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum Security {
        IDENTITY("identity"),
        CLIENT("client"),
        NONE("none");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Security(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum AuthMethod {
        NONE("none"),
        USERNAME_PASSWORD("username_password");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private AuthMethod(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

