/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.manager.DefaultDeploymentPermissions;
import org.wildfly.swarm.config.security.manager.DefaultDeploymentPermissionsConsumer;
import org.wildfly.swarm.config.security.manager.DefaultDeploymentPermissionsSupplier;

@Address(value="/subsystem=security-manager")
@ResourceType(value="subsystem")
@Implicit
public class SecurityManager<T extends SecurityManager<T>> {
    private String key = "security-manager";
    private PropertyChangeSupport pcs;
    private SecurityManagerResources subresources = new SecurityManagerResources();

    public SecurityManager() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public SecurityManagerResources subresources() {
        return this.subresources;
    }

    public T defaultDeploymentPermissions(DefaultDeploymentPermissions value) {
        this.subresources.defaultDeploymentPermissions = value;
        return (T)this;
    }

    public T defaultDeploymentPermissions(DefaultDeploymentPermissionsConsumer consumer) {
        DefaultDeploymentPermissions child = new DefaultDeploymentPermissions();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.defaultDeploymentPermissions = child;
        return (T)this;
    }

    public T defaultDeploymentPermissions() {
        DefaultDeploymentPermissions child = new DefaultDeploymentPermissions();
        this.subresources.defaultDeploymentPermissions = child;
        return (T)this;
    }

    public T defaultDeploymentPermissions(DefaultDeploymentPermissionsSupplier supplier) {
        this.subresources.defaultDeploymentPermissions = supplier.get();
        return (T)this;
    }

    public static class SecurityManagerResources {
        private DefaultDeploymentPermissions defaultDeploymentPermissions;

        @Subresource
        public DefaultDeploymentPermissions defaultDeploymentPermissions() {
            return this.defaultDeploymentPermissions;
        }
    }
}

