/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/server=*/address-setting=*")
@ResourceType(value="address-setting")
public class AddressSetting<T extends AddressSetting<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private AddressFullPolicy addressFullPolicy;
    private String deadLetterAddress;
    private String expiryAddress;
    private Long expiryDelay;
    private Boolean lastValueQueue;
    private Integer maxDeliveryAttempts;
    private Long maxRedeliveryDelay;
    private Long maxSizeBytes;
    private Integer messageCounterHistoryDayLimit;
    private Integer pageMaxCacheSize;
    private Long pageSizeBytes;
    private Long redeliveryDelay;
    private Double redeliveryMultiplier;
    private Long redistributionDelay;
    private Boolean sendToDlaOnNoRoute;
    private Long slowConsumerCheckPeriod;
    private SlowConsumerPolicy slowConsumerPolicy;
    private Long slowConsumerThreshold;

    public AddressSetting(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @Deprecated
    public T addressFullPolicy(String addressFullPolicy) {
        if (addressFullPolicy == null) {
            this.addressFullPolicy = null;
        } else {
            boolean found = false;
            for (AddressFullPolicy e : AddressFullPolicy.values()) {
                if (!e.toString().equals(addressFullPolicy)) continue;
                this.addressFullPolicy(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", addressFullPolicy, Arrays.asList(AddressFullPolicy.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="address-full-policy")
    public AddressFullPolicy addressFullPolicy() {
        return this.addressFullPolicy;
    }

    public T addressFullPolicy(AddressFullPolicy value) {
        AddressFullPolicy oldValue = this.addressFullPolicy;
        this.addressFullPolicy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("addressFullPolicy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="dead-letter-address")
    public String deadLetterAddress() {
        return this.deadLetterAddress;
    }

    public T deadLetterAddress(String value) {
        String oldValue = this.deadLetterAddress;
        this.deadLetterAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("deadLetterAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="expiry-address")
    public String expiryAddress() {
        return this.expiryAddress;
    }

    public T expiryAddress(String value) {
        String oldValue = this.expiryAddress;
        this.expiryAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("expiryAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="expiry-delay")
    public Long expiryDelay() {
        return this.expiryDelay;
    }

    public T expiryDelay(Long value) {
        Long oldValue = this.expiryDelay;
        this.expiryDelay = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("expiryDelay", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="last-value-queue")
    public Boolean lastValueQueue() {
        return this.lastValueQueue;
    }

    public T lastValueQueue(Boolean value) {
        Boolean oldValue = this.lastValueQueue;
        this.lastValueQueue = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("lastValueQueue", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-delivery-attempts")
    public Integer maxDeliveryAttempts() {
        return this.maxDeliveryAttempts;
    }

    public T maxDeliveryAttempts(Integer value) {
        Integer oldValue = this.maxDeliveryAttempts;
        this.maxDeliveryAttempts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxDeliveryAttempts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-redelivery-delay")
    public Long maxRedeliveryDelay() {
        return this.maxRedeliveryDelay;
    }

    public T maxRedeliveryDelay(Long value) {
        Long oldValue = this.maxRedeliveryDelay;
        this.maxRedeliveryDelay = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRedeliveryDelay", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-size-bytes")
    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public T maxSizeBytes(Long value) {
        Long oldValue = this.maxSizeBytes;
        this.maxSizeBytes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxSizeBytes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="message-counter-history-day-limit")
    public Integer messageCounterHistoryDayLimit() {
        return this.messageCounterHistoryDayLimit;
    }

    public T messageCounterHistoryDayLimit(Integer value) {
        Integer oldValue = this.messageCounterHistoryDayLimit;
        this.messageCounterHistoryDayLimit = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("messageCounterHistoryDayLimit", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="page-max-cache-size")
    public Integer pageMaxCacheSize() {
        return this.pageMaxCacheSize;
    }

    public T pageMaxCacheSize(Integer value) {
        Integer oldValue = this.pageMaxCacheSize;
        this.pageMaxCacheSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("pageMaxCacheSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="page-size-bytes")
    public Long pageSizeBytes() {
        return this.pageSizeBytes;
    }

    public T pageSizeBytes(Long value) {
        Long oldValue = this.pageSizeBytes;
        this.pageSizeBytes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("pageSizeBytes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="redelivery-delay")
    public Long redeliveryDelay() {
        return this.redeliveryDelay;
    }

    public T redeliveryDelay(Long value) {
        Long oldValue = this.redeliveryDelay;
        this.redeliveryDelay = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("redeliveryDelay", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="redelivery-multiplier")
    public Double redeliveryMultiplier() {
        return this.redeliveryMultiplier;
    }

    public T redeliveryMultiplier(Double value) {
        Double oldValue = this.redeliveryMultiplier;
        this.redeliveryMultiplier = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("redeliveryMultiplier", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="redistribution-delay")
    public Long redistributionDelay() {
        return this.redistributionDelay;
    }

    public T redistributionDelay(Long value) {
        Long oldValue = this.redistributionDelay;
        this.redistributionDelay = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("redistributionDelay", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="send-to-dla-on-no-route")
    public Boolean sendToDlaOnNoRoute() {
        return this.sendToDlaOnNoRoute;
    }

    public T sendToDlaOnNoRoute(Boolean value) {
        Boolean oldValue = this.sendToDlaOnNoRoute;
        this.sendToDlaOnNoRoute = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sendToDlaOnNoRoute", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="slow-consumer-check-period")
    public Long slowConsumerCheckPeriod() {
        return this.slowConsumerCheckPeriod;
    }

    public T slowConsumerCheckPeriod(Long value) {
        Long oldValue = this.slowConsumerCheckPeriod;
        this.slowConsumerCheckPeriod = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("slowConsumerCheckPeriod", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    public T slowConsumerPolicy(String slowConsumerPolicy) {
        if (slowConsumerPolicy == null) {
            this.slowConsumerPolicy = null;
        } else {
            boolean found = false;
            for (SlowConsumerPolicy e : SlowConsumerPolicy.values()) {
                if (!e.toString().equals(slowConsumerPolicy)) continue;
                this.slowConsumerPolicy(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", slowConsumerPolicy, Arrays.asList(SlowConsumerPolicy.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="slow-consumer-policy")
    public SlowConsumerPolicy slowConsumerPolicy() {
        return this.slowConsumerPolicy;
    }

    public T slowConsumerPolicy(SlowConsumerPolicy value) {
        SlowConsumerPolicy oldValue = this.slowConsumerPolicy;
        this.slowConsumerPolicy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("slowConsumerPolicy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="slow-consumer-threshold")
    public Long slowConsumerThreshold() {
        return this.slowConsumerThreshold;
    }

    public T slowConsumerThreshold(Long value) {
        Long oldValue = this.slowConsumerThreshold;
        this.slowConsumerThreshold = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("slowConsumerThreshold", oldValue, value);
        }
        return (T)this;
    }

    public static enum SlowConsumerPolicy {
        KILL("KILL"),
        NOTIFY("NOTIFY");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private SlowConsumerPolicy(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum AddressFullPolicy {
        DROP("DROP"),
        PAGE("PAGE"),
        BLOCK("BLOCK"),
        FAIL("FAIL");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private AddressFullPolicy(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

