package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.ejb3.PassivationStore;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface PassivationStoreConsumer<T extends PassivationStore<T>> {

	/**
	 * Configure a pre-constructed instance of PassivationStore resource
	 * 
	 * @parameter Instance of PassivationStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default PassivationStoreConsumer<T> andThen(
			PassivationStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}