package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.jca.Workmanager;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface WorkmanagerConsumer<T extends Workmanager<T>> {

	/**
	 * Configure a pre-constructed instance of Workmanager resource
	 * 
	 * @parameter Instance of Workmanager to configure
	 * @return nothing
	 */
	void accept(T value);

	default WorkmanagerConsumer<T> andThen(WorkmanagerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}