package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.management.access.JsonFormatter;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface JsonFormatterConsumer<T extends JsonFormatter<T>> {

	/**
	 * Configure a pre-constructed instance of JsonFormatter resource
	 * 
	 * @parameter Instance of JsonFormatter to configure
	 * @return nothing
	 */
	void accept(T value);

	default JsonFormatterConsumer<T> andThen(JsonFormatterConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}