package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.security.security_domain.JaspiAuthentication;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface JaspiAuthenticationConsumer<T extends JaspiAuthentication<T>> {

	/**
	 * Configure a pre-constructed instance of JaspiAuthentication resource
	 * 
	 * @parameter Instance of JaspiAuthentication to configure
	 * @return nothing
	 */
	void accept(T value);

	default JaspiAuthenticationConsumer<T> andThen(
			JaspiAuthenticationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}