/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.transactions;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.transactions.log_store.Transactions;
import org.wildfly.swarm.config.transactions.log_store.TransactionsConsumer;
import org.wildfly.swarm.config.transactions.log_store.TransactionsSupplier;

@Address(value="/subsystem=transactions/log-store=log-store")
@ResourceType(value="log-store")
@Implicit
public class LogStore<T extends LogStore<T>> {
    private String key = "log-store";
    private PropertyChangeSupport pcs;
    private Boolean exposeAllLogs;
    private String type;
    private LogStoreResources subresources = new LogStoreResources();

    public LogStore() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="expose-all-logs")
    public Boolean exposeAllLogs() {
        return this.exposeAllLogs;
    }

    public T exposeAllLogs(Boolean value) {
        Boolean oldValue = this.exposeAllLogs;
        this.exposeAllLogs = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exposeAllLogs", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="type")
    public String type() {
        return this.type;
    }

    public T type(String value) {
        String oldValue = this.type;
        this.type = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("type", oldValue, value);
        }
        return (T)this;
    }

    public LogStoreResources subresources() {
        return this.subresources;
    }

    public T transactions(List<Transactions> value) {
        this.subresources.transactions = value;
        return (T)this;
    }

    public T transactions(Transactions value) {
        this.subresources.transactions.add(value);
        return (T)this;
    }

    public T transactions(String childKey, TransactionsConsumer consumer) {
        Transactions child = new Transactions(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.transactions(child);
        return (T)this;
    }

    public T transactions(String childKey) {
        this.transactions(childKey, null);
        return (T)this;
    }

    public T transactions(TransactionsSupplier supplier) {
        this.transactions(supplier.get());
        return (T)this;
    }

    public static class LogStoreResources {
        private List<Transactions> transactions = new ArrayList<Transactions>();

        @Subresource
        public List<Transactions> transactions() {
            return this.transactions;
        }

        public Transactions transactions(String key) {
            return this.transactions.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

