/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.webservices;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=webservices/client-config=*/property=*", "/subsystem=webservices/endpoint-config=*/property=*"})
@ResourceType(value="property")
public class Property<T extends Property<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private String value;

    public Property(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="value")
    public String value() {
        return this.value;
    }

    public T value(String value) {
        String oldValue = this.value;
        this.value = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("value", oldValue, value);
        }
        return (T)this;
    }
}

