package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.logging.PeriodicRotatingFileHandlerConsumer;
import org.wildfly.swarm.config.logging.PeriodicRotatingFileHandlerSupplier;
import org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler;
import org.wildfly.swarm.config.logging.LoggerConsumer;
import org.wildfly.swarm.config.logging.LoggerSupplier;
import org.wildfly.swarm.config.logging.Logger;
import org.wildfly.swarm.config.logging.AsyncHandlerConsumer;
import org.wildfly.swarm.config.logging.AsyncHandlerSupplier;
import org.wildfly.swarm.config.logging.AsyncHandler;
import org.wildfly.swarm.config.logging.FileHandlerConsumer;
import org.wildfly.swarm.config.logging.FileHandlerSupplier;
import org.wildfly.swarm.config.logging.FileHandler;
import org.wildfly.swarm.config.logging.SizeRotatingFileHandlerConsumer;
import org.wildfly.swarm.config.logging.SizeRotatingFileHandlerSupplier;
import org.wildfly.swarm.config.logging.SizeRotatingFileHandler;
import org.wildfly.swarm.config.logging.SyslogHandlerConsumer;
import org.wildfly.swarm.config.logging.SyslogHandlerSupplier;
import org.wildfly.swarm.config.logging.SyslogHandler;
import org.wildfly.swarm.config.logging.LoggingProfileConsumer;
import org.wildfly.swarm.config.logging.LoggingProfileSupplier;
import org.wildfly.swarm.config.logging.LoggingProfile;
import org.wildfly.swarm.config.logging.CustomFormatterConsumer;
import org.wildfly.swarm.config.logging.CustomFormatterSupplier;
import org.wildfly.swarm.config.logging.CustomFormatter;
import org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandlerConsumer;
import org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandlerSupplier;
import org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler;
import org.wildfly.swarm.config.logging.ConsoleHandlerConsumer;
import org.wildfly.swarm.config.logging.ConsoleHandlerSupplier;
import org.wildfly.swarm.config.logging.ConsoleHandler;
import org.wildfly.swarm.config.logging.LogFileConsumer;
import org.wildfly.swarm.config.logging.LogFileSupplier;
import org.wildfly.swarm.config.logging.LogFile;
import org.wildfly.swarm.config.logging.PatternFormatterConsumer;
import org.wildfly.swarm.config.logging.PatternFormatterSupplier;
import org.wildfly.swarm.config.logging.PatternFormatter;
import org.wildfly.swarm.config.logging.CustomHandlerConsumer;
import org.wildfly.swarm.config.logging.CustomHandlerSupplier;
import org.wildfly.swarm.config.logging.CustomHandler;
import org.wildfly.swarm.config.logging.RootLogger;
import org.wildfly.swarm.config.logging.RootLoggerConsumer;
import org.wildfly.swarm.config.logging.RootLoggerSupplier;
/**
 * The configuration of the logging subsystem.
 */
@Address("/subsystem=logging")
@ResourceType("subsystem")
@Implicit
public class Logging<T extends Logging<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean addLoggingApiDependencies;
	private Boolean useDeploymentLoggingConfig;
	private LoggingResources subresources = new LoggingResources();

	public Logging() {
		this.key = "logging";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Indicates whether or not logging API dependencies should be added to
	 * deployments during the deployment process. A value of true will add the
	 * dependencies to the deployment. A value of false will skip the deployment
	 * from being processed for logging API dependencies.
	 */
	@ModelNodeBinding(detypedName = "add-logging-api-dependencies")
	public Boolean addLoggingApiDependencies() {
		return this.addLoggingApiDependencies;
	}

	/**
	 * Indicates whether or not logging API dependencies should be added to
	 * deployments during the deployment process. A value of true will add the
	 * dependencies to the deployment. A value of false will skip the deployment
	 * from being processed for logging API dependencies.
	 */
	@SuppressWarnings("unchecked")
	public T addLoggingApiDependencies(Boolean value) {
		Object oldValue = this.addLoggingApiDependencies;
		this.addLoggingApiDependencies = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("addLoggingApiDependencies", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Indicates whether or not deployments should use a logging configuration
	 * file found in the deployment to configure the log manager. If set to true
	 * and a logging configuration file was found in the deployments META-INF or
	 * WEB-INF/classes directory, then a log manager will be configured with
	 * those settings. If set false the servers logging configuration will be
	 * used regardless of any logging configuration files supplied in the
	 * deployment.
	 */
	@ModelNodeBinding(detypedName = "use-deployment-logging-config")
	public Boolean useDeploymentLoggingConfig() {
		return this.useDeploymentLoggingConfig;
	}

	/**
	 * Indicates whether or not deployments should use a logging configuration
	 * file found in the deployment to configure the log manager. If set to true
	 * and a logging configuration file was found in the deployments META-INF or
	 * WEB-INF/classes directory, then a log manager will be configured with
	 * those settings. If set false the servers logging configuration will be
	 * used regardless of any logging configuration files supplied in the
	 * deployment.
	 */
	@SuppressWarnings("unchecked")
	public T useDeploymentLoggingConfig(Boolean value) {
		Object oldValue = this.useDeploymentLoggingConfig;
		this.useDeploymentLoggingConfig = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useDeploymentLoggingConfig", oldValue,
					value);
		return (T) this;
	}

	public LoggingResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all PeriodicRotatingFileHandler objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PeriodicRotatingFileHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public T periodicRotatingFileHandlers(
			List<PeriodicRotatingFileHandler> value) {
		this.subresources.periodicRotatingFileHandlers = value;
		return (T) this;
	}

	/**
	 * Add the PeriodicRotatingFileHandler object to the list of subresources
	 * 
	 * @param value
	 *            The PeriodicRotatingFileHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T periodicRotatingFileHandler(PeriodicRotatingFileHandler value) {
		this.subresources.periodicRotatingFileHandlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PeriodicRotatingFileHandler object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PeriodicRotatingFileHandler resource
	 * @param config
	 *            The PeriodicRotatingFileHandlerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T periodicRotatingFileHandler(String childKey,
			PeriodicRotatingFileHandlerConsumer consumer) {
		PeriodicRotatingFileHandler<? extends PeriodicRotatingFileHandler> child = new PeriodicRotatingFileHandler<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		periodicRotatingFileHandler(child);
		return (T) this;
	}

	/**
	 * Create and configure a PeriodicRotatingFileHandler object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PeriodicRotatingFileHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T periodicRotatingFileHandler(String childKey) {
		periodicRotatingFileHandler(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PeriodicRotatingFileHandler object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T periodicRotatingFileHandler(
			PeriodicRotatingFileHandlerSupplier supplier) {
		periodicRotatingFileHandler(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Logger objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Logger objects.
	 */
	@SuppressWarnings("unchecked")
	public T loggers(List<Logger> value) {
		this.subresources.loggers = value;
		return (T) this;
	}

	/**
	 * Add the Logger object to the list of subresources
	 * 
	 * @param value
	 *            The Logger to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T logger(Logger value) {
		this.subresources.loggers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Logger object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Logger resource
	 * @param config
	 *            The LoggerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T logger(String childKey, LoggerConsumer consumer) {
		Logger<? extends Logger> child = new Logger<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		logger(child);
		return (T) this;
	}

	/**
	 * Create and configure a Logger object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Logger resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T logger(String childKey) {
		logger(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Logger object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T logger(LoggerSupplier supplier) {
		logger(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AsyncHandler objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AsyncHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public T asyncHandlers(List<AsyncHandler> value) {
		this.subresources.asyncHandlers = value;
		return (T) this;
	}

	/**
	 * Add the AsyncHandler object to the list of subresources
	 * 
	 * @param value
	 *            The AsyncHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T asyncHandler(AsyncHandler value) {
		this.subresources.asyncHandlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AsyncHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AsyncHandler resource
	 * @param config
	 *            The AsyncHandlerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T asyncHandler(String childKey, AsyncHandlerConsumer consumer) {
		AsyncHandler<? extends AsyncHandler> child = new AsyncHandler<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		asyncHandler(child);
		return (T) this;
	}

	/**
	 * Create and configure a AsyncHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AsyncHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T asyncHandler(String childKey) {
		asyncHandler(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AsyncHandler object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T asyncHandler(AsyncHandlerSupplier supplier) {
		asyncHandler(supplier.get());
		return (T) this;
	}

	/**
	 * Add all FileHandler objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of FileHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public T fileHandlers(List<FileHandler> value) {
		this.subresources.fileHandlers = value;
		return (T) this;
	}

	/**
	 * Add the FileHandler object to the list of subresources
	 * 
	 * @param value
	 *            The FileHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T fileHandler(FileHandler value) {
		this.subresources.fileHandlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a FileHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the FileHandler resource
	 * @param config
	 *            The FileHandlerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T fileHandler(String childKey, FileHandlerConsumer consumer) {
		FileHandler<? extends FileHandler> child = new FileHandler<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		fileHandler(child);
		return (T) this;
	}

	/**
	 * Create and configure a FileHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the FileHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T fileHandler(String childKey) {
		fileHandler(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied FileHandler object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T fileHandler(FileHandlerSupplier supplier) {
		fileHandler(supplier.get());
		return (T) this;
	}

	/**
	 * Add all SizeRotatingFileHandler objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SizeRotatingFileHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public T sizeRotatingFileHandlers(List<SizeRotatingFileHandler> value) {
		this.subresources.sizeRotatingFileHandlers = value;
		return (T) this;
	}

	/**
	 * Add the SizeRotatingFileHandler object to the list of subresources
	 * 
	 * @param value
	 *            The SizeRotatingFileHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T sizeRotatingFileHandler(SizeRotatingFileHandler value) {
		this.subresources.sizeRotatingFileHandlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SizeRotatingFileHandler object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SizeRotatingFileHandler resource
	 * @param config
	 *            The SizeRotatingFileHandlerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T sizeRotatingFileHandler(String childKey,
			SizeRotatingFileHandlerConsumer consumer) {
		SizeRotatingFileHandler<? extends SizeRotatingFileHandler> child = new SizeRotatingFileHandler<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		sizeRotatingFileHandler(child);
		return (T) this;
	}

	/**
	 * Create and configure a SizeRotatingFileHandler object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SizeRotatingFileHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T sizeRotatingFileHandler(String childKey) {
		sizeRotatingFileHandler(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SizeRotatingFileHandler object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T sizeRotatingFileHandler(SizeRotatingFileHandlerSupplier supplier) {
		sizeRotatingFileHandler(supplier.get());
		return (T) this;
	}

	/**
	 * Add all SyslogHandler objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SyslogHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public T syslogHandlers(List<SyslogHandler> value) {
		this.subresources.syslogHandlers = value;
		return (T) this;
	}

	/**
	 * Add the SyslogHandler object to the list of subresources
	 * 
	 * @param value
	 *            The SyslogHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T syslogHandler(SyslogHandler value) {
		this.subresources.syslogHandlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SyslogHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SyslogHandler resource
	 * @param config
	 *            The SyslogHandlerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T syslogHandler(String childKey, SyslogHandlerConsumer consumer) {
		SyslogHandler<? extends SyslogHandler> child = new SyslogHandler<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		syslogHandler(child);
		return (T) this;
	}

	/**
	 * Create and configure a SyslogHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SyslogHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T syslogHandler(String childKey) {
		syslogHandler(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SyslogHandler object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T syslogHandler(SyslogHandlerSupplier supplier) {
		syslogHandler(supplier.get());
		return (T) this;
	}

	/**
	 * Add all LoggingProfile objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LoggingProfile objects.
	 */
	@SuppressWarnings("unchecked")
	public T loggingProfiles(List<LoggingProfile> value) {
		this.subresources.loggingProfiles = value;
		return (T) this;
	}

	/**
	 * Add the LoggingProfile object to the list of subresources
	 * 
	 * @param value
	 *            The LoggingProfile to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loggingProfile(LoggingProfile value) {
		this.subresources.loggingProfiles.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LoggingProfile object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LoggingProfile resource
	 * @param config
	 *            The LoggingProfileConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loggingProfile(String childKey, LoggingProfileConsumer consumer) {
		LoggingProfile<? extends LoggingProfile> child = new LoggingProfile<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		loggingProfile(child);
		return (T) this;
	}

	/**
	 * Create and configure a LoggingProfile object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LoggingProfile resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loggingProfile(String childKey) {
		loggingProfile(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LoggingProfile object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T loggingProfile(LoggingProfileSupplier supplier) {
		loggingProfile(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomFormatter objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomFormatter objects.
	 */
	@SuppressWarnings("unchecked")
	public T customFormatters(List<CustomFormatter> value) {
		this.subresources.customFormatters = value;
		return (T) this;
	}

	/**
	 * Add the CustomFormatter object to the list of subresources
	 * 
	 * @param value
	 *            The CustomFormatter to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customFormatter(CustomFormatter value) {
		this.subresources.customFormatters.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomFormatter object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CustomFormatter resource
	 * @param config
	 *            The CustomFormatterConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customFormatter(String childKey, CustomFormatterConsumer consumer) {
		CustomFormatter<? extends CustomFormatter> child = new CustomFormatter<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customFormatter(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomFormatter object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CustomFormatter resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customFormatter(String childKey) {
		customFormatter(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomFormatter object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T customFormatter(CustomFormatterSupplier supplier) {
		customFormatter(supplier.get());
		return (T) this;
	}

	/**
	 * Add all PeriodicSizeRotatingFileHandler objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PeriodicSizeRotatingFileHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public T periodicSizeRotatingFileHandlers(
			List<PeriodicSizeRotatingFileHandler> value) {
		this.subresources.periodicSizeRotatingFileHandlers = value;
		return (T) this;
	}

	/**
	 * Add the PeriodicSizeRotatingFileHandler object to the list of
	 * subresources
	 * 
	 * @param value
	 *            The PeriodicSizeRotatingFileHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T periodicSizeRotatingFileHandler(
			PeriodicSizeRotatingFileHandler value) {
		this.subresources.periodicSizeRotatingFileHandlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PeriodicSizeRotatingFileHandler object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the PeriodicSizeRotatingFileHandler resource
	 * @param config
	 *            The PeriodicSizeRotatingFileHandlerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T periodicSizeRotatingFileHandler(String childKey,
			PeriodicSizeRotatingFileHandlerConsumer consumer) {
		PeriodicSizeRotatingFileHandler<? extends PeriodicSizeRotatingFileHandler> child = new PeriodicSizeRotatingFileHandler<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		periodicSizeRotatingFileHandler(child);
		return (T) this;
	}

	/**
	 * Create and configure a PeriodicSizeRotatingFileHandler object to the list
	 * of subresources
	 * 
	 * @param key
	 *            The key for the PeriodicSizeRotatingFileHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T periodicSizeRotatingFileHandler(String childKey) {
		periodicSizeRotatingFileHandler(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PeriodicSizeRotatingFileHandler object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T periodicSizeRotatingFileHandler(
			PeriodicSizeRotatingFileHandlerSupplier supplier) {
		periodicSizeRotatingFileHandler(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConsoleHandler objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConsoleHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public T consoleHandlers(List<ConsoleHandler> value) {
		this.subresources.consoleHandlers = value;
		return (T) this;
	}

	/**
	 * Add the ConsoleHandler object to the list of subresources
	 * 
	 * @param value
	 *            The ConsoleHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T consoleHandler(ConsoleHandler value) {
		this.subresources.consoleHandlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConsoleHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ConsoleHandler resource
	 * @param config
	 *            The ConsoleHandlerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T consoleHandler(String childKey, ConsoleHandlerConsumer consumer) {
		ConsoleHandler<? extends ConsoleHandler> child = new ConsoleHandler<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		consoleHandler(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConsoleHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ConsoleHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T consoleHandler(String childKey) {
		consoleHandler(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConsoleHandler object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T consoleHandler(ConsoleHandlerSupplier supplier) {
		consoleHandler(supplier.get());
		return (T) this;
	}

	/**
	 * Add all LogFile objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LogFile objects.
	 */
	@SuppressWarnings("unchecked")
	public T logFiles(List<LogFile> value) {
		this.subresources.logFiles = value;
		return (T) this;
	}

	/**
	 * Add the LogFile object to the list of subresources
	 * 
	 * @param value
	 *            The LogFile to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T logFile(LogFile value) {
		this.subresources.logFiles.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LogFile object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LogFile resource
	 * @param config
	 *            The LogFileConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T logFile(String childKey, LogFileConsumer consumer) {
		LogFile<? extends LogFile> child = new LogFile<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		logFile(child);
		return (T) this;
	}

	/**
	 * Create and configure a LogFile object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LogFile resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T logFile(String childKey) {
		logFile(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LogFile object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T logFile(LogFileSupplier supplier) {
		logFile(supplier.get());
		return (T) this;
	}

	/**
	 * Add all PatternFormatter objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PatternFormatter objects.
	 */
	@SuppressWarnings("unchecked")
	public T patternFormatters(List<PatternFormatter> value) {
		this.subresources.patternFormatters = value;
		return (T) this;
	}

	/**
	 * Add the PatternFormatter object to the list of subresources
	 * 
	 * @param value
	 *            The PatternFormatter to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T patternFormatter(PatternFormatter value) {
		this.subresources.patternFormatters.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PatternFormatter object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PatternFormatter resource
	 * @param config
	 *            The PatternFormatterConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T patternFormatter(String childKey, PatternFormatterConsumer consumer) {
		PatternFormatter<? extends PatternFormatter> child = new PatternFormatter<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		patternFormatter(child);
		return (T) this;
	}

	/**
	 * Create and configure a PatternFormatter object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PatternFormatter resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T patternFormatter(String childKey) {
		patternFormatter(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PatternFormatter object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T patternFormatter(PatternFormatterSupplier supplier) {
		patternFormatter(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomHandler objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public T customHandlers(List<CustomHandler> value) {
		this.subresources.customHandlers = value;
		return (T) this;
	}

	/**
	 * Add the CustomHandler object to the list of subresources
	 * 
	 * @param value
	 *            The CustomHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customHandler(CustomHandler value) {
		this.subresources.customHandlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CustomHandler resource
	 * @param config
	 *            The CustomHandlerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customHandler(String childKey, CustomHandlerConsumer consumer) {
		CustomHandler<? extends CustomHandler> child = new CustomHandler<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customHandler(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CustomHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customHandler(String childKey) {
		customHandler(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomHandler object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T customHandler(CustomHandlerSupplier supplier) {
		customHandler(supplier.get());
		return (T) this;
	}

	/**
	 * Defines the root logger for this log context.
	 */
	@SuppressWarnings("unchecked")
	public T rootLogger(RootLogger value) {
		this.subresources.rootLogger = value;
		return (T) this;
	}

	/**
	 * Defines the root logger for this log context.
	 */
	@SuppressWarnings("unchecked")
	public T rootLogger(RootLoggerConsumer consumer) {
		RootLogger<? extends RootLogger> child = new RootLogger<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.rootLogger = child;
		return (T) this;
	}

	/**
	 * Defines the root logger for this log context.
	 */
	@SuppressWarnings("unchecked")
	public T rootLogger() {
		RootLogger<? extends RootLogger> child = new RootLogger<>();
		this.subresources.rootLogger = child;
		return (T) this;
	}

	/**
	 * Defines the root logger for this log context.
	 */
	@SuppressWarnings("unchecked")
	public T rootLogger(RootLoggerSupplier supplier) {
		this.subresources.rootLogger = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for Logging
	 */
	public static class LoggingResources {
		/**
		 * Defines a handler which writes to a file, rotating the log after a
		 * time period derived from the given suffix string, which should be in
		 * a format understood by java.text.SimpleDateFormat.
		 */
		private List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a logger category.
		 */
		private List<Logger> loggers = new java.util.ArrayList<>();
		/**
		 * Defines a handler which writes to the sub-handlers in an asynchronous
		 * thread. Used for handlers which introduce a substantial amount of
		 * lag.
		 */
		private List<AsyncHandler> asyncHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a handler which writes to a file.
		 */
		private List<FileHandler> fileHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a handler which writes to a file, rotating the log after the
		 * size of the file grows beyond a certain point and keeping a fixed
		 * number of backups.
		 */
		private List<SizeRotatingFileHandler> sizeRotatingFileHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a syslog handler.
		 */
		private List<SyslogHandler> syslogHandlers = new java.util.ArrayList<>();
		/**
		 * The configuration of the logging subsystem.
		 */
		private List<LoggingProfile> loggingProfiles = new java.util.ArrayList<>();
		/**
		 * A custom formatter to be used with handlers. Note that most log
		 * records are formatted in the printf format. Formatters may require
		 * invocation of the
		 * org.jboss.logmanager.ExtLogRecord#getFormattedMessage() for the
		 * message to be properly formatted.
		 */
		private List<CustomFormatter> customFormatters = new java.util.ArrayList<>();
		/**
		 * Defines a handler which writes to a file, rotating the log after a
		 * time period derived from the given suffix string or after the size of
		 * the file grows beyond a certain point and keeping a fixed number of
		 * backups. The suffix should be in a format understood by the
		 * java.text.SimpleDateFormat. Any backups rotated by the suffix will
		 * not be purged during a size rotation.
		 */
		private List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a handler which writes to the console.
		 */
		private List<ConsoleHandler> consoleHandlers = new java.util.ArrayList<>();
		/**
		 * Log files that are available to be read.
		 */
		private List<LogFile> logFiles = new java.util.ArrayList<>();
		/**
		 * A pattern formatter to be used with handlers.
		 */
		private List<PatternFormatter> patternFormatters = new java.util.ArrayList<>();
		/**
		 * Defines a custom logging handler. The custom handler must extend
		 * java.util.logging.Handler.
		 */
		private List<CustomHandler> customHandlers = new java.util.ArrayList<>();
		private RootLogger rootLogger;

		/**
		 * Get the list of PeriodicRotatingFileHandler resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers() {
			return this.periodicRotatingFileHandlers;
		}

		public PeriodicRotatingFileHandler periodicRotatingFileHandler(
				String key) {
			return this.periodicRotatingFileHandlers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Logger resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Logger> loggers() {
			return this.loggers;
		}

		public Logger logger(String key) {
			return this.loggers.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of AsyncHandler resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AsyncHandler> asyncHandlers() {
			return this.asyncHandlers;
		}

		public AsyncHandler asyncHandler(String key) {
			return this.asyncHandlers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of FileHandler resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<FileHandler> fileHandlers() {
			return this.fileHandlers;
		}

		public FileHandler fileHandler(String key) {
			return this.fileHandlers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of SizeRotatingFileHandler resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SizeRotatingFileHandler> sizeRotatingFileHandlers() {
			return this.sizeRotatingFileHandlers;
		}

		public SizeRotatingFileHandler sizeRotatingFileHandler(String key) {
			return this.sizeRotatingFileHandlers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of SyslogHandler resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SyslogHandler> syslogHandlers() {
			return this.syslogHandlers;
		}

		public SyslogHandler syslogHandler(String key) {
			return this.syslogHandlers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of LoggingProfile resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LoggingProfile> loggingProfiles() {
			return this.loggingProfiles;
		}

		public LoggingProfile loggingProfile(String key) {
			return this.loggingProfiles.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CustomFormatter resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomFormatter> customFormatters() {
			return this.customFormatters;
		}

		public CustomFormatter customFormatter(String key) {
			return this.customFormatters.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of PeriodicSizeRotatingFileHandler resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers() {
			return this.periodicSizeRotatingFileHandlers;
		}

		public PeriodicSizeRotatingFileHandler periodicSizeRotatingFileHandler(
				String key) {
			return this.periodicSizeRotatingFileHandlers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ConsoleHandler resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConsoleHandler> consoleHandlers() {
			return this.consoleHandlers;
		}

		public ConsoleHandler consoleHandler(String key) {
			return this.consoleHandlers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of LogFile resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LogFile> logFiles() {
			return this.logFiles;
		}

		public LogFile logFile(String key) {
			return this.logFiles.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of PatternFormatter resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PatternFormatter> patternFormatters() {
			return this.patternFormatters;
		}

		public PatternFormatter patternFormatter(String key) {
			return this.patternFormatters.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CustomHandler resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomHandler> customHandlers() {
			return this.customHandlers;
		}

		public CustomHandler customHandler(String key) {
			return this.customHandlers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Defines the root logger for this log context.
		 */
		@Subresource
		public RootLogger rootLogger() {
			return this.rootLogger;
		}
	}
}