package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A passivation store
 */
@Address("/subsystem=ejb3/passivation-store=*")
@ResourceType("passivation-store")
public class PassivationStore<T extends PassivationStore<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String beanCache;
	private String cacheContainer;
	private Integer maxSize;

	public PassivationStore(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@ModelNodeBinding(detypedName = "bean-cache")
	public String beanCache() {
		return this.beanCache;
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@SuppressWarnings("unchecked")
	public T beanCache(String value) {
		Object oldValue = this.beanCache;
		this.beanCache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("beanCache", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings
	 * caches
	 */
	@ModelNodeBinding(detypedName = "cache-container")
	public String cacheContainer() {
		return this.cacheContainer;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings
	 * caches
	 */
	@SuppressWarnings("unchecked")
	public T cacheContainer(String value) {
		Object oldValue = this.cacheContainer;
		this.cacheContainer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cacheContainer", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old
	 * beans to passivate
	 */
	@ModelNodeBinding(detypedName = "max-size")
	public Integer maxSize() {
		return this.maxSize;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old
	 * beans to passivate
	 */
	@SuppressWarnings("unchecked")
	public T maxSize(Integer value) {
		Object oldValue = this.maxSize;
		this.maxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxSize", oldValue, value);
		return (T) this;
	}
}