package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A cache for which this cache acts as a backup (for use with cross site
 * replication).
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/component=backup-for",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/component=backup-for"})
@ResourceType("component")
@Implicit
public class BackupForComponent<T extends BackupForComponent<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String remoteCache;
	private String remoteSite;

	public BackupForComponent() {
		this.key = "backup-for";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the remote cache for which this cache acts as a backup.
	 */
	@ModelNodeBinding(detypedName = "remote-cache")
	public String remoteCache() {
		return this.remoteCache;
	}

	/**
	 * The name of the remote cache for which this cache acts as a backup.
	 */
	@SuppressWarnings("unchecked")
	public T remoteCache(String value) {
		Object oldValue = this.remoteCache;
		this.remoteCache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("remoteCache", oldValue, value);
		return (T) this;
	}

	/**
	 * The site of the remote cache for which this cache acts as a backup.
	 */
	@ModelNodeBinding(detypedName = "remote-site")
	public String remoteSite() {
		return this.remoteSite;
	}

	/**
	 * The site of the remote cache for which this cache acts as a backup.
	 */
	@SuppressWarnings("unchecked")
	public T remoteSite(String value) {
		Object oldValue = this.remoteSite;
		this.remoteSite = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("remoteSite", oldValue, value);
		return (T) this;
	}
}