package org.wildfly.swarm.config.jgroups.stack.relay;

import org.wildfly.swarm.config.jgroups.stack.relay.RELAY2;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface RELAY2Consumer<T extends RELAY2<T>> {

	/**
	 * Configure a pre-constructed instance of RELAY2 resource
	 * 
	 * @parameter Instance of RELAY2 to configure
	 * @return nothing
	 */
	void accept(T value);

	default RELAY2Consumer<T> andThen(RELAY2Consumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}