package org.wildfly.swarm.config.jmx;

import org.wildfly.swarm.config.jmx.JMXRemotingConnector;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface JMXRemotingConnectorConsumer<T extends JMXRemotingConnector<T>> {

	/**
	 * Configure a pre-constructed instance of JMXRemotingConnector resource
	 * 
	 * @parameter Instance of JMXRemotingConnector to configure
	 * @return nothing
	 */
	void accept(T value);

	default JMXRemotingConnectorConsumer<T> andThen(
			JMXRemotingConnectorConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}