package org.wildfly.swarm.config.management.access.role_mapping;

import org.wildfly.swarm.config.management.access.role_mapping.Include;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface IncludeConsumer<T extends Include<T>> {

	/**
	 * Configure a pre-constructed instance of Include resource
	 * 
	 * @parameter Instance of Include to configure
	 * @return nothing
	 */
	void accept(T value);

	default IncludeConsumer<T> andThen(IncludeConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}