package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCache;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ByAccessTimeCacheConsumer<T extends ByAccessTimeCache<T>> {

	/**
	 * Configure a pre-constructed instance of ByAccessTimeCache resource
	 * 
	 * @parameter Instance of ByAccessTimeCache to configure
	 * @return nothing
	 */
	void accept(T value);

	default ByAccessTimeCacheConsumer<T> andThen(
			ByAccessTimeCacheConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}