package org.wildfly.swarm.config.security.security_domain.authentication;

import org.wildfly.swarm.config.security.security_domain.authentication.LoginModule;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface LoginModuleConsumer<T extends LoginModule<T>> {

	/**
	 * Configure a pre-constructed instance of LoginModule resource
	 * 
	 * @parameter Instance of LoginModule to configure
	 * @return nothing
	 */
	void accept(T value);

	default LoginModuleConsumer<T> andThen(LoginModuleConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}