package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.undertow.configuration.Gzip;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface GzipConsumer<T extends Gzip<T>> {

	/**
	 * Configure a pre-constructed instance of Gzip resource
	 * 
	 * @parameter Instance of Gzip to configure
	 * @return nothing
	 */
	void accept(T value);

	default GzipConsumer<T> andThen(GzipConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}