package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.undertow.configuration.ModCluster;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ModClusterConsumer<T extends ModCluster<T>> {

	/**
	 * Configure a pre-constructed instance of ModCluster resource
	 * 
	 * @parameter Instance of ModCluster to configure
	 * @return nothing
	 */
	void accept(T value);

	default ModClusterConsumer<T> andThen(ModClusterConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}