package org.wildfly.swarm.config.webservices;

import org.wildfly.swarm.config.webservices.PostHandlerChain;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface PostHandlerChainConsumer<T extends PostHandlerChain<T>> {

	/**
	 * Configure a pre-constructed instance of PostHandlerChain resource
	 * 
	 * @parameter Instance of PostHandlerChain to configure
	 * @return nothing
	 */
	void accept(T value);

	default PostHandlerChainConsumer<T> andThen(
			PostHandlerChainConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}