/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.server.host;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.server.host.FilterRef;
import org.wildfly.swarm.config.undertow.server.host.FilterRefConsumer;
import org.wildfly.swarm.config.undertow.server.host.FilterRefSupplier;

@Address(value="/subsystem=undertow/server=*/host=*/location=*")
@ResourceType(value="location")
public class Location<T extends Location<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private String handler;
    private LocationResources subresources = new LocationResources();

    public Location(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="handler")
    public String handler() {
        return this.handler;
    }

    public T handler(String value) {
        String oldValue = this.handler;
        this.handler = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("handler", oldValue, value);
        }
        return (T)this;
    }

    public LocationResources subresources() {
        return this.subresources;
    }

    public T filterRefs(List<FilterRef> value) {
        this.subresources.filterRefs = value;
        return (T)this;
    }

    public T filterRef(FilterRef value) {
        this.subresources.filterRefs.add(value);
        return (T)this;
    }

    public T filterRef(String childKey, FilterRefConsumer consumer) {
        FilterRef child = new FilterRef(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.filterRef(child);
        return (T)this;
    }

    public T filterRef(String childKey) {
        this.filterRef(childKey, null);
        return (T)this;
    }

    public T filterRef(FilterRefSupplier supplier) {
        this.filterRef(supplier.get());
        return (T)this;
    }

    public static class LocationResources {
        private List<FilterRef> filterRefs = new ArrayList<FilterRef>();

        @Subresource
        public List<FilterRef> filterRefs() {
            return this.filterRefs;
        }

        public FilterRef filterRef(String key) {
            return this.filterRefs.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

