package org.wildfly.swarm.config.jgroups;

import org.wildfly.swarm.config.jgroups.Protocol;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ProtocolConsumer<T extends Protocol<T>> {

	/**
	 * Configure a pre-constructed instance of Protocol resource
	 * 
	 * @parameter Instance of Protocol to configure
	 * @return nothing
	 */
	void accept(T value);

	default ProtocolConsumer<T> andThen(ProtocolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}