package org.wildfly.swarm.config.jgroups.stack.relay;

import org.wildfly.swarm.config.jgroups.stack.relay.RemoteSite;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface RemoteSiteConsumer<T extends RemoteSite<T>> {

	/**
	 * Configure a pre-constructed instance of RemoteSite resource
	 * 
	 * @parameter Instance of RemoteSite to configure
	 * @return nothing
	 */
	void accept(T value);

	default RemoteSiteConsumer<T> andThen(RemoteSiteConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}