package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.management.access.SyslogHandler;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface SyslogHandlerConsumer<T extends SyslogHandler<T>> {

	/**
	 * Configure a pre-constructed instance of SyslogHandler resource
	 * 
	 * @parameter Instance of SyslogHandler to configure
	 * @return nothing
	 */
	void accept(T value);

	default SyslogHandlerConsumer<T> andThen(SyslogHandlerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}