/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.naming.Binding;
import org.wildfly.swarm.config.naming.BindingConsumer;
import org.wildfly.swarm.config.naming.BindingSupplier;
import org.wildfly.swarm.config.naming.RemoteNamingService;
import org.wildfly.swarm.config.naming.RemoteNamingServiceConsumer;
import org.wildfly.swarm.config.naming.RemoteNamingServiceSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=naming")
@ResourceType(value="subsystem")
@Implicit
public class Naming<T extends Naming<T>> {
    private String key = "naming";
    private PropertyChangeSupport pcs;
    private NamingResources subresources = new NamingResources();

    public Naming() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public NamingResources subresources() {
        return this.subresources;
    }

    public T bindings(List<Binding> value) {
        this.subresources.bindings = value;
        return (T)this;
    }

    public T binding(Binding value) {
        this.subresources.bindings.add(value);
        return (T)this;
    }

    public T binding(String childKey, BindingConsumer consumer) {
        Binding child = new Binding(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.binding(child);
        return (T)this;
    }

    public T binding(String childKey) {
        this.binding(childKey, null);
        return (T)this;
    }

    public T binding(BindingSupplier supplier) {
        this.binding(supplier.get());
        return (T)this;
    }

    public T remoteNamingService(RemoteNamingService value) {
        this.subresources.remoteNamingService = value;
        return (T)this;
    }

    public T remoteNamingService(RemoteNamingServiceConsumer consumer) {
        RemoteNamingService child = new RemoteNamingService();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.remoteNamingService = child;
        return (T)this;
    }

    public T remoteNamingService() {
        RemoteNamingService child = new RemoteNamingService();
        this.subresources.remoteNamingService = child;
        return (T)this;
    }

    public T remoteNamingService(RemoteNamingServiceSupplier supplier) {
        this.subresources.remoteNamingService = supplier.get();
        return (T)this;
    }

    public static class NamingResources {
        private List<Binding> bindings = new ArrayList<Binding>();
        private RemoteNamingService remoteNamingService;

        @Subresource
        public List<Binding> bindings() {
            return this.bindings;
        }

        public Binding binding(String key) {
            return this.bindings.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public RemoteNamingService remoteNamingService() {
            return this.remoteNamingService;
        }
    }
}

