/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.datasources;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.datasources.FlushStrategy;
import org.wildfly.swarm.config.datasources.xa_data_source.XADatasourceProperties;
import org.wildfly.swarm.config.datasources.xa_data_source.XADatasourcePropertiesConsumer;
import org.wildfly.swarm.config.datasources.xa_data_source.XADatasourcePropertiesSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=datasources/xa-data-source=*")
@ResourceType(value="xa-data-source")
public class XADataSource<T extends XADataSource<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private Integer allocationRetry;
    private Long allocationRetryWaitMillis;
    private Boolean allowMultipleUsers;
    private Boolean backgroundValidation;
    private Long backgroundValidationMillis;
    private Long blockingTimeoutWaitMillis;
    private String capacityDecrementerClass;
    private Map capacityDecrementerProperties;
    private String capacityIncrementerClass;
    private Map capacityIncrementerProperties;
    private String checkValidConnectionSql;
    private Boolean connectable;
    private String connectionListenerClass;
    private Map connectionListenerProperty;
    private String driverName;
    private Boolean enlistmentTrace;
    private String exceptionSorterClassName;
    private Map exceptionSorterProperties;
    private FlushStrategy flushStrategy;
    private Long idleTimeoutMinutes;
    private Integer initialPoolSize;
    private Boolean interleaving;
    private String jndiName;
    private Integer maxPoolSize;
    private String mcp;
    private Integer minPoolSize;
    private String newConnectionSql;
    private Boolean noRecovery;
    private Boolean noTxSeparatePool;
    private Boolean padXid;
    private String password;
    private Boolean poolPrefill;
    private Boolean poolUseStrictMin;
    private Long preparedStatementsCacheSize;
    private Long queryTimeout;
    private String reauthPluginClassName;
    private Map reauthPluginProperties;
    private String recoveryPassword;
    private String recoveryPluginClassName;
    private Map recoveryPluginProperties;
    private String recoverySecurityDomain;
    private String recoveryUsername;
    private Boolean sameRmOverride;
    private String securityDomain;
    private Boolean setTxQueryTimeout;
    private Boolean sharePreparedStatements;
    private Boolean spy;
    private String staleConnectionCheckerClassName;
    private Map staleConnectionCheckerProperties;
    private Boolean statisticsEnabled;
    private String trackStatements;
    private Boolean tracking;
    private String transactionIsolation;
    private String urlDelimiter;
    private String urlProperty;
    private String urlSelectorStrategyClassName;
    private Boolean useCcm;
    private Boolean useFastFail;
    private Boolean useJavaContext;
    private Long useTryLock;
    private String userName;
    private String validConnectionCheckerClassName;
    private Map validConnectionCheckerProperties;
    private Boolean validateOnMatch;
    private Boolean wrapXaResource;
    private String xaDatasourceClass;
    private Integer xaResourceTimeout;
    private XADataSourceResources subresources = new XADataSourceResources();

    public XADataSource(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="allocation-retry")
    public Integer allocationRetry() {
        return this.allocationRetry;
    }

    public T allocationRetry(Integer value) {
        Integer oldValue = this.allocationRetry;
        this.allocationRetry = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allocationRetry", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allocation-retry-wait-millis")
    public Long allocationRetryWaitMillis() {
        return this.allocationRetryWaitMillis;
    }

    public T allocationRetryWaitMillis(Long value) {
        Long oldValue = this.allocationRetryWaitMillis;
        this.allocationRetryWaitMillis = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allocationRetryWaitMillis", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allow-multiple-users")
    public Boolean allowMultipleUsers() {
        return this.allowMultipleUsers;
    }

    public T allowMultipleUsers(Boolean value) {
        Boolean oldValue = this.allowMultipleUsers;
        this.allowMultipleUsers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowMultipleUsers", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="background-validation")
    public Boolean backgroundValidation() {
        return this.backgroundValidation;
    }

    public T backgroundValidation(Boolean value) {
        Boolean oldValue = this.backgroundValidation;
        this.backgroundValidation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("backgroundValidation", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="background-validation-millis")
    public Long backgroundValidationMillis() {
        return this.backgroundValidationMillis;
    }

    public T backgroundValidationMillis(Long value) {
        Long oldValue = this.backgroundValidationMillis;
        this.backgroundValidationMillis = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("backgroundValidationMillis", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="blocking-timeout-wait-millis")
    public Long blockingTimeoutWaitMillis() {
        return this.blockingTimeoutWaitMillis;
    }

    public T blockingTimeoutWaitMillis(Long value) {
        Long oldValue = this.blockingTimeoutWaitMillis;
        this.blockingTimeoutWaitMillis = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("blockingTimeoutWaitMillis", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-decrementer-class")
    public String capacityDecrementerClass() {
        return this.capacityDecrementerClass;
    }

    public T capacityDecrementerClass(String value) {
        String oldValue = this.capacityDecrementerClass;
        this.capacityDecrementerClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityDecrementerClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-decrementer-properties")
    public Map capacityDecrementerProperties() {
        return this.capacityDecrementerProperties;
    }

    public T capacityDecrementerProperties(Map value) {
        Map oldValue = this.capacityDecrementerProperties;
        this.capacityDecrementerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityDecrementerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T capacityDecrementerProperty(String key, Object value) {
        if (this.capacityDecrementerProperties == null) {
            this.capacityDecrementerProperties = new HashMap();
        }
        this.capacityDecrementerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-incrementer-class")
    public String capacityIncrementerClass() {
        return this.capacityIncrementerClass;
    }

    public T capacityIncrementerClass(String value) {
        String oldValue = this.capacityIncrementerClass;
        this.capacityIncrementerClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityIncrementerClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-incrementer-properties")
    public Map capacityIncrementerProperties() {
        return this.capacityIncrementerProperties;
    }

    public T capacityIncrementerProperties(Map value) {
        Map oldValue = this.capacityIncrementerProperties;
        this.capacityIncrementerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityIncrementerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T capacityIncrementerProperty(String key, Object value) {
        if (this.capacityIncrementerProperties == null) {
            this.capacityIncrementerProperties = new HashMap();
        }
        this.capacityIncrementerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="check-valid-connection-sql")
    public String checkValidConnectionSql() {
        return this.checkValidConnectionSql;
    }

    public T checkValidConnectionSql(String value) {
        String oldValue = this.checkValidConnectionSql;
        this.checkValidConnectionSql = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("checkValidConnectionSql", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connectable")
    public Boolean connectable() {
        return this.connectable;
    }

    public T connectable(Boolean value) {
        Boolean oldValue = this.connectable;
        this.connectable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-listener-class")
    public String connectionListenerClass() {
        return this.connectionListenerClass;
    }

    public T connectionListenerClass(String value) {
        String oldValue = this.connectionListenerClass;
        this.connectionListenerClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionListenerClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-listener-property")
    public Map connectionListenerProperty() {
        return this.connectionListenerProperty;
    }

    public T connectionListenerProperty(Map value) {
        Map oldValue = this.connectionListenerProperty;
        this.connectionListenerProperty = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionListenerProperty", oldValue, value);
        }
        return (T)this;
    }

    public T connectionListenerProperty(String key, Object value) {
        if (this.connectionListenerProperty == null) {
            this.connectionListenerProperty = new HashMap();
        }
        this.connectionListenerProperty.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="driver-name")
    public String driverName() {
        return this.driverName;
    }

    public T driverName(String value) {
        String oldValue = this.driverName;
        this.driverName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("driverName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enlistment-trace")
    public Boolean enlistmentTrace() {
        return this.enlistmentTrace;
    }

    public T enlistmentTrace(Boolean value) {
        Boolean oldValue = this.enlistmentTrace;
        this.enlistmentTrace = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enlistmentTrace", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="exception-sorter-class-name")
    public String exceptionSorterClassName() {
        return this.exceptionSorterClassName;
    }

    public T exceptionSorterClassName(String value) {
        String oldValue = this.exceptionSorterClassName;
        this.exceptionSorterClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exceptionSorterClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="exception-sorter-properties")
    public Map exceptionSorterProperties() {
        return this.exceptionSorterProperties;
    }

    public T exceptionSorterProperties(Map value) {
        Map oldValue = this.exceptionSorterProperties;
        this.exceptionSorterProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exceptionSorterProperties", oldValue, value);
        }
        return (T)this;
    }

    public T exceptionSorterProperty(String key, Object value) {
        if (this.exceptionSorterProperties == null) {
            this.exceptionSorterProperties = new HashMap();
        }
        this.exceptionSorterProperties.put(key, value);
        return (T)this;
    }

    @Deprecated
    public T flushStrategy(String flushStrategy) {
        if (flushStrategy == null) {
            this.flushStrategy = null;
        } else {
            boolean found = false;
            for (FlushStrategy e : FlushStrategy.values()) {
                if (!e.toString().equals(flushStrategy)) continue;
                this.flushStrategy(e);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException(String.format("Value '%s' not valid. Valid values are: %s", flushStrategy, Arrays.asList(FlushStrategy.values())));
            }
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="flush-strategy")
    public FlushStrategy flushStrategy() {
        return this.flushStrategy;
    }

    public T flushStrategy(FlushStrategy value) {
        FlushStrategy oldValue = this.flushStrategy;
        this.flushStrategy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("flushStrategy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="idle-timeout-minutes")
    public Long idleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    public T idleTimeoutMinutes(Long value) {
        Long oldValue = this.idleTimeoutMinutes;
        this.idleTimeoutMinutes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("idleTimeoutMinutes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="initial-pool-size")
    public Integer initialPoolSize() {
        return this.initialPoolSize;
    }

    public T initialPoolSize(Integer value) {
        Integer oldValue = this.initialPoolSize;
        this.initialPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("initialPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="interleaving")
    public Boolean interleaving() {
        return this.interleaving;
    }

    public T interleaving(Boolean value) {
        Boolean oldValue = this.interleaving;
        this.interleaving = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("interleaving", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-pool-size")
    public Integer maxPoolSize() {
        return this.maxPoolSize;
    }

    public T maxPoolSize(Integer value) {
        Integer oldValue = this.maxPoolSize;
        this.maxPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="mcp")
    public String mcp() {
        return this.mcp;
    }

    public T mcp(String value) {
        String oldValue = this.mcp;
        this.mcp = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("mcp", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="min-pool-size")
    public Integer minPoolSize() {
        return this.minPoolSize;
    }

    public T minPoolSize(Integer value) {
        Integer oldValue = this.minPoolSize;
        this.minPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("minPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="new-connection-sql")
    public String newConnectionSql() {
        return this.newConnectionSql;
    }

    public T newConnectionSql(String value) {
        String oldValue = this.newConnectionSql;
        this.newConnectionSql = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("newConnectionSql", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="no-recovery")
    public Boolean noRecovery() {
        return this.noRecovery;
    }

    public T noRecovery(Boolean value) {
        Boolean oldValue = this.noRecovery;
        this.noRecovery = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("noRecovery", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="no-tx-separate-pool")
    public Boolean noTxSeparatePool() {
        return this.noTxSeparatePool;
    }

    public T noTxSeparatePool(Boolean value) {
        Boolean oldValue = this.noTxSeparatePool;
        this.noTxSeparatePool = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("noTxSeparatePool", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pad-xid")
    public Boolean padXid() {
        return this.padXid;
    }

    public T padXid(Boolean value) {
        Boolean oldValue = this.padXid;
        this.padXid = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("padXid", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="password")
    public String password() {
        return this.password;
    }

    public T password(String value) {
        String oldValue = this.password;
        this.password = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("password", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pool-prefill")
    public Boolean poolPrefill() {
        return this.poolPrefill;
    }

    public T poolPrefill(Boolean value) {
        Boolean oldValue = this.poolPrefill;
        this.poolPrefill = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("poolPrefill", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pool-use-strict-min")
    public Boolean poolUseStrictMin() {
        return this.poolUseStrictMin;
    }

    public T poolUseStrictMin(Boolean value) {
        Boolean oldValue = this.poolUseStrictMin;
        this.poolUseStrictMin = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("poolUseStrictMin", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="prepared-statements-cache-size")
    public Long preparedStatementsCacheSize() {
        return this.preparedStatementsCacheSize;
    }

    public T preparedStatementsCacheSize(Long value) {
        Long oldValue = this.preparedStatementsCacheSize;
        this.preparedStatementsCacheSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("preparedStatementsCacheSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="query-timeout")
    public Long queryTimeout() {
        return this.queryTimeout;
    }

    public T queryTimeout(Long value) {
        Long oldValue = this.queryTimeout;
        this.queryTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queryTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reauth-plugin-class-name")
    public String reauthPluginClassName() {
        return this.reauthPluginClassName;
    }

    public T reauthPluginClassName(String value) {
        String oldValue = this.reauthPluginClassName;
        this.reauthPluginClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reauthPluginClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reauth-plugin-properties")
    public Map reauthPluginProperties() {
        return this.reauthPluginProperties;
    }

    public T reauthPluginProperties(Map value) {
        Map oldValue = this.reauthPluginProperties;
        this.reauthPluginProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reauthPluginProperties", oldValue, value);
        }
        return (T)this;
    }

    public T reauthPluginProperty(String key, Object value) {
        if (this.reauthPluginProperties == null) {
            this.reauthPluginProperties = new HashMap();
        }
        this.reauthPluginProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-password")
    public String recoveryPassword() {
        return this.recoveryPassword;
    }

    public T recoveryPassword(String value) {
        String oldValue = this.recoveryPassword;
        this.recoveryPassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryPassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-plugin-class-name")
    public String recoveryPluginClassName() {
        return this.recoveryPluginClassName;
    }

    public T recoveryPluginClassName(String value) {
        String oldValue = this.recoveryPluginClassName;
        this.recoveryPluginClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryPluginClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-plugin-properties")
    public Map recoveryPluginProperties() {
        return this.recoveryPluginProperties;
    }

    public T recoveryPluginProperties(Map value) {
        Map oldValue = this.recoveryPluginProperties;
        this.recoveryPluginProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryPluginProperties", oldValue, value);
        }
        return (T)this;
    }

    public T recoveryPluginProperty(String key, Object value) {
        if (this.recoveryPluginProperties == null) {
            this.recoveryPluginProperties = new HashMap();
        }
        this.recoveryPluginProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-security-domain")
    public String recoverySecurityDomain() {
        return this.recoverySecurityDomain;
    }

    public T recoverySecurityDomain(String value) {
        String oldValue = this.recoverySecurityDomain;
        this.recoverySecurityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoverySecurityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-username")
    public String recoveryUsername() {
        return this.recoveryUsername;
    }

    public T recoveryUsername(String value) {
        String oldValue = this.recoveryUsername;
        this.recoveryUsername = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryUsername", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="same-rm-override")
    public Boolean sameRmOverride() {
        return this.sameRmOverride;
    }

    public T sameRmOverride(Boolean value) {
        Boolean oldValue = this.sameRmOverride;
        this.sameRmOverride = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sameRmOverride", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="set-tx-query-timeout")
    public Boolean setTxQueryTimeout() {
        return this.setTxQueryTimeout;
    }

    public T setTxQueryTimeout(Boolean value) {
        Boolean oldValue = this.setTxQueryTimeout;
        this.setTxQueryTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("setTxQueryTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="share-prepared-statements")
    public Boolean sharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    public T sharePreparedStatements(Boolean value) {
        Boolean oldValue = this.sharePreparedStatements;
        this.sharePreparedStatements = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sharePreparedStatements", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="spy")
    public Boolean spy() {
        return this.spy;
    }

    public T spy(Boolean value) {
        Boolean oldValue = this.spy;
        this.spy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("spy", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stale-connection-checker-class-name")
    public String staleConnectionCheckerClassName() {
        return this.staleConnectionCheckerClassName;
    }

    public T staleConnectionCheckerClassName(String value) {
        String oldValue = this.staleConnectionCheckerClassName;
        this.staleConnectionCheckerClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("staleConnectionCheckerClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stale-connection-checker-properties")
    public Map staleConnectionCheckerProperties() {
        return this.staleConnectionCheckerProperties;
    }

    public T staleConnectionCheckerProperties(Map value) {
        Map oldValue = this.staleConnectionCheckerProperties;
        this.staleConnectionCheckerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("staleConnectionCheckerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T staleConnectionCheckerProperty(String key, Object value) {
        if (this.staleConnectionCheckerProperties == null) {
            this.staleConnectionCheckerProperties = new HashMap();
        }
        this.staleConnectionCheckerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        Boolean oldValue = this.statisticsEnabled;
        this.statisticsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="track-statements")
    public String trackStatements() {
        return this.trackStatements;
    }

    public T trackStatements(String value) {
        String oldValue = this.trackStatements;
        this.trackStatements = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("trackStatements", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="tracking")
    public Boolean tracking() {
        return this.tracking;
    }

    public T tracking(Boolean value) {
        Boolean oldValue = this.tracking;
        this.tracking = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tracking", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transaction-isolation")
    public String transactionIsolation() {
        return this.transactionIsolation;
    }

    public T transactionIsolation(String value) {
        String oldValue = this.transactionIsolation;
        this.transactionIsolation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transactionIsolation", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="url-delimiter")
    public String urlDelimiter() {
        return this.urlDelimiter;
    }

    public T urlDelimiter(String value) {
        String oldValue = this.urlDelimiter;
        this.urlDelimiter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("urlDelimiter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="url-property")
    public String urlProperty() {
        return this.urlProperty;
    }

    public T urlProperty(String value) {
        String oldValue = this.urlProperty;
        this.urlProperty = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("urlProperty", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="url-selector-strategy-class-name")
    public String urlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public T urlSelectorStrategyClassName(String value) {
        String oldValue = this.urlSelectorStrategyClassName;
        this.urlSelectorStrategyClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("urlSelectorStrategyClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-ccm")
    public Boolean useCcm() {
        return this.useCcm;
    }

    public T useCcm(Boolean value) {
        Boolean oldValue = this.useCcm;
        this.useCcm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useCcm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-fast-fail")
    public Boolean useFastFail() {
        return this.useFastFail;
    }

    public T useFastFail(Boolean value) {
        Boolean oldValue = this.useFastFail;
        this.useFastFail = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useFastFail", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-java-context")
    public Boolean useJavaContext() {
        return this.useJavaContext;
    }

    public T useJavaContext(Boolean value) {
        Boolean oldValue = this.useJavaContext;
        this.useJavaContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useJavaContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-try-lock")
    public Long useTryLock() {
        return this.useTryLock;
    }

    public T useTryLock(Long value) {
        Long oldValue = this.useTryLock;
        this.useTryLock = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useTryLock", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="user-name")
    public String userName() {
        return this.userName;
    }

    public T userName(String value) {
        String oldValue = this.userName;
        this.userName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("userName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="valid-connection-checker-class-name")
    public String validConnectionCheckerClassName() {
        return this.validConnectionCheckerClassName;
    }

    public T validConnectionCheckerClassName(String value) {
        String oldValue = this.validConnectionCheckerClassName;
        this.validConnectionCheckerClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("validConnectionCheckerClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="valid-connection-checker-properties")
    public Map validConnectionCheckerProperties() {
        return this.validConnectionCheckerProperties;
    }

    public T validConnectionCheckerProperties(Map value) {
        Map oldValue = this.validConnectionCheckerProperties;
        this.validConnectionCheckerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("validConnectionCheckerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T validConnectionCheckerProperty(String key, Object value) {
        if (this.validConnectionCheckerProperties == null) {
            this.validConnectionCheckerProperties = new HashMap();
        }
        this.validConnectionCheckerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="validate-on-match")
    public Boolean validateOnMatch() {
        return this.validateOnMatch;
    }

    public T validateOnMatch(Boolean value) {
        Boolean oldValue = this.validateOnMatch;
        this.validateOnMatch = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("validateOnMatch", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wrap-xa-resource")
    public Boolean wrapXaResource() {
        return this.wrapXaResource;
    }

    public T wrapXaResource(Boolean value) {
        Boolean oldValue = this.wrapXaResource;
        this.wrapXaResource = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wrapXaResource", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="xa-datasource-class")
    public String xaDatasourceClass() {
        return this.xaDatasourceClass;
    }

    public T xaDatasourceClass(String value) {
        String oldValue = this.xaDatasourceClass;
        this.xaDatasourceClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("xaDatasourceClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="xa-resource-timeout")
    public Integer xaResourceTimeout() {
        return this.xaResourceTimeout;
    }

    public T xaResourceTimeout(Integer value) {
        Integer oldValue = this.xaResourceTimeout;
        this.xaResourceTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("xaResourceTimeout", oldValue, value);
        }
        return (T)this;
    }

    public XADataSourceResources subresources() {
        return this.subresources;
    }

    public T xaDatasourceProperties(List<XADatasourceProperties> value) {
        this.subresources.xaDatasourceProperties = value;
        return (T)this;
    }

    public T xaDatasourceProperties(XADatasourceProperties value) {
        this.subresources.xaDatasourceProperties.add(value);
        return (T)this;
    }

    public T xaDatasourceProperties(String childKey, XADatasourcePropertiesConsumer consumer) {
        XADatasourceProperties child = new XADatasourceProperties(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.xaDatasourceProperties(child);
        return (T)this;
    }

    public T xaDatasourceProperties(String childKey) {
        this.xaDatasourceProperties(childKey, null);
        return (T)this;
    }

    public T xaDatasourceProperties(XADatasourcePropertiesSupplier supplier) {
        this.xaDatasourceProperties(supplier.get());
        return (T)this;
    }

    public static class XADataSourceResources {
        private List<XADatasourceProperties> xaDatasourceProperties = new ArrayList<XADatasourceProperties>();

        @Subresource
        public List<XADatasourceProperties> xaDatasourceProperties() {
            return this.xaDatasourceProperties;
        }

        public XADatasourceProperties xaDatasourceProperties(String key) {
            return this.xaDatasourceProperties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

