/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.configuration.mod_cluster;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroupConsumer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroupSupplier;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.NodeConsumer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.NodeSupplier;

@Address(value="/subsystem=undertow/configuration=filter/mod-cluster=*/balancer=*")
@ResourceType(value="balancer")
public class Balancer<T extends Balancer<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private Integer maxAttempts;
    private Boolean stickySession;
    private String stickySessionCookie;
    private Boolean stickySessionForce;
    private String stickySessionPath;
    private Boolean stickySessionRemove;
    private Integer waitWorker;
    private BalancerResources subresources = new BalancerResources();

    public Balancer(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="max-attempts")
    public Integer maxAttempts() {
        return this.maxAttempts;
    }

    public T maxAttempts(Integer value) {
        Integer oldValue = this.maxAttempts;
        this.maxAttempts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxAttempts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sticky-session")
    public Boolean stickySession() {
        return this.stickySession;
    }

    public T stickySession(Boolean value) {
        Boolean oldValue = this.stickySession;
        this.stickySession = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stickySession", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sticky-session-cookie")
    public String stickySessionCookie() {
        return this.stickySessionCookie;
    }

    public T stickySessionCookie(String value) {
        String oldValue = this.stickySessionCookie;
        this.stickySessionCookie = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stickySessionCookie", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sticky-session-force")
    public Boolean stickySessionForce() {
        return this.stickySessionForce;
    }

    public T stickySessionForce(Boolean value) {
        Boolean oldValue = this.stickySessionForce;
        this.stickySessionForce = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stickySessionForce", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sticky-session-path")
    public String stickySessionPath() {
        return this.stickySessionPath;
    }

    public T stickySessionPath(String value) {
        String oldValue = this.stickySessionPath;
        this.stickySessionPath = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stickySessionPath", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sticky-session-remove")
    public Boolean stickySessionRemove() {
        return this.stickySessionRemove;
    }

    public T stickySessionRemove(Boolean value) {
        Boolean oldValue = this.stickySessionRemove;
        this.stickySessionRemove = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stickySessionRemove", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wait-worker")
    public Integer waitWorker() {
        return this.waitWorker;
    }

    public T waitWorker(Integer value) {
        Integer oldValue = this.waitWorker;
        this.waitWorker = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("waitWorker", oldValue, value);
        }
        return (T)this;
    }

    public BalancerResources subresources() {
        return this.subresources;
    }

    public T nodes(List<Node> value) {
        this.subresources.nodes = value;
        return (T)this;
    }

    public T node(Node value) {
        this.subresources.nodes.add(value);
        return (T)this;
    }

    public T node(String childKey, NodeConsumer consumer) {
        Node child = new Node(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.node(child);
        return (T)this;
    }

    public T node(String childKey) {
        this.node(childKey, null);
        return (T)this;
    }

    public T node(NodeSupplier supplier) {
        this.node(supplier.get());
        return (T)this;
    }

    public T loadBalancingGroups(List<LoadBalancingGroup> value) {
        this.subresources.loadBalancingGroups = value;
        return (T)this;
    }

    public T loadBalancingGroup(LoadBalancingGroup value) {
        this.subresources.loadBalancingGroups.add(value);
        return (T)this;
    }

    public T loadBalancingGroup(String childKey, LoadBalancingGroupConsumer consumer) {
        LoadBalancingGroup child = new LoadBalancingGroup(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.loadBalancingGroup(child);
        return (T)this;
    }

    public T loadBalancingGroup(String childKey) {
        this.loadBalancingGroup(childKey, null);
        return (T)this;
    }

    public T loadBalancingGroup(LoadBalancingGroupSupplier supplier) {
        this.loadBalancingGroup(supplier.get());
        return (T)this;
    }

    public static class BalancerResources {
        private List<Node> nodes = new ArrayList<Node>();
        private List<LoadBalancingGroup> loadBalancingGroups = new ArrayList<LoadBalancingGroup>();

        @Subresource
        public List<Node> nodes() {
            return this.nodes;
        }

        public Node node(String key) {
            return this.nodes.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<LoadBalancingGroup> loadBalancingGroups() {
            return this.loadBalancingGroups;
        }

        public LoadBalancingGroup loadBalancingGroup(String key) {
            return this.loadBalancingGroups.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

