package org.wildfly.swarm.config.batch.jberet;

import org.wildfly.swarm.config.batch.jberet.JDBCJobRepository;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface JDBCJobRepositoryConsumer<T extends JDBCJobRepository<T>> {

	/**
	 * Configure a pre-constructed instance of JDBCJobRepository resource
	 * 
	 * @parameter Instance of JDBCJobRepository to configure
	 * @return nothing
	 */
	void accept(T value);

	default JDBCJobRepositoryConsumer<T> andThen(
			JDBCJobRepositoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}