package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The IIOP service
 */
@Address("/subsystem=ejb3/service=iiop")
@ResourceType("service")
@Implicit
public class IIOPService<T extends IIOPService<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean enableByDefault;
	private Boolean useQualifiedName;

	public IIOPService() {
		this.key = "iiop";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * If this is true EJB's will be exposed over IIOP by default, otherwise it
	 * needs to be explicitly enabled in the deployment descriptor
	 */
	@ModelNodeBinding(detypedName = "enable-by-default")
	public Boolean enableByDefault() {
		return this.enableByDefault;
	}

	/**
	 * If this is true EJB's will be exposed over IIOP by default, otherwise it
	 * needs to be explicitly enabled in the deployment descriptor
	 */
	@SuppressWarnings("unchecked")
	public T enableByDefault(Boolean value) {
		Object oldValue = this.enableByDefault;
		this.enableByDefault = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableByDefault", oldValue, value);
		return (T) this;
	}

	/**
	 * If true EJB names will be bound into the naming service with the
	 * application and module name prepended to the name (e.g.
	 * myapp/mymodule/MyEjb)
	 */
	@ModelNodeBinding(detypedName = "use-qualified-name")
	public Boolean useQualifiedName() {
		return this.useQualifiedName;
	}

	/**
	 * If true EJB names will be bound into the naming service with the
	 * application and module name prepended to the name (e.g.
	 * myapp/mymodule/MyEjb)
	 */
	@SuppressWarnings("unchecked")
	public T useQualifiedName(Boolean value) {
		Object oldValue = this.useQualifiedName;
		this.useQualifiedName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useQualifiedName", oldValue, value);
		return (T) this;
	}
}