package org.wildfly.swarm.config.mail;

import org.wildfly.swarm.config.mail.MailSession;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface MailSessionConsumer<T extends MailSession<T>> {

	/**
	 * Configure a pre-constructed instance of MailSession resource
	 * 
	 * @parameter Instance of MailSession to configure
	 * @return nothing
	 */
	void accept(T value);

	default MailSessionConsumer<T> andThen(MailSessionConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}