package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.RuntimeQueue;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface RuntimeQueueConsumer<T extends RuntimeQueue<T>> {

	/**
	 * Configure a pre-constructed instance of RuntimeQueue resource
	 * 
	 * @parameter Instance of RuntimeQueue to configure
	 * @return nothing
	 */
	void accept(T value);

	default RuntimeQueueConsumer<T> andThen(RuntimeQueueConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}