package org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Load metric definition
 */
@Address("/subsystem=modcluster/mod-cluster-config=configuration/dynamic-load-provider=configuration/custom-load-metric=*")
@ResourceType("custom-load-metric")
public class CustomLoadMetric<T extends CustomLoadMetric<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Double capacity;
	private String attributeClass;
	private Map property;
	private Integer weight;

	public CustomLoadMetric(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Capacity of the metric.
	 */
	@ModelNodeBinding(detypedName = "capacity")
	public Double capacity() {
		return this.capacity;
	}

	/**
	 * Capacity of the metric.
	 */
	@SuppressWarnings("unchecked")
	public T capacity(Double value) {
		Object oldValue = this.capacity;
		this.capacity = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacity", oldValue, value);
		return (T) this;
	}

	/**
	 * Class name of the custom metric.
	 */
	@ModelNodeBinding(detypedName = "class")
	public String attributeClass() {
		return this.attributeClass;
	}

	/**
	 * Class name of the custom metric.
	 */
	@SuppressWarnings("unchecked")
	public T attributeClass(String value) {
		Object oldValue = this.attributeClass;
		this.attributeClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeClass", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties for the metric.
	 */
	@ModelNodeBinding(detypedName = "property")
	public Map property() {
		return this.property;
	}

	/**
	 * Properties for the metric.
	 */
	@SuppressWarnings("unchecked")
	public T property(Map value) {
		Object oldValue = this.property;
		this.property = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("property", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties for the metric.
	 */
	@SuppressWarnings("unchecked")
	public T property(String key, Object value) {
		if (this.property == null) {
			this.property = new java.util.HashMap<>();
		}
		this.property.put(key, value);
		return (T) this;
	}

	/**
	 * Weight of the metric.
	 */
	@ModelNodeBinding(detypedName = "weight")
	public Integer weight() {
		return this.weight;
	}

	/**
	 * Weight of the metric.
	 */
	@SuppressWarnings("unchecked")
	public T weight(Integer value) {
		Object oldValue = this.weight;
		this.weight = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("weight", oldValue, value);
		return (T) this;
	}
}